/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.net;

import ch.qos.logback.core.AppenderBase;
import ch.qos.logback.core.Layout;
import ch.qos.logback.core.rolling.TriggeringPolicy;
import ch.qos.logback.core.util.OptionHelper;
import java.util.Date;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;

public abstract class SMTPAppenderBase
extends AppenderBase {
    protected Layout layout;
    protected Layout subjectLayout;
    private String to;
    private String from;
    private String subjectStr = null;
    private String smtpHost;
    protected Message msg;
    protected TriggeringPolicy evaluator;

    protected abstract Layout makeSubjectLayout(String var1);

    public void start() {
        Properties props = new Properties(System.getProperties());
        if (this.smtpHost != null) {
            props.put("mail.smtp.host", this.smtpHost);
        }
        Session session = Session.getInstance((Properties)props, null);
        this.msg = new MimeMessage(session);
        try {
            if (this.from != null) {
                this.msg.setFrom((Address)this.getAddress(this.from));
            } else {
                this.msg.setFrom();
            }
            this.msg.setRecipients(Message.RecipientType.TO, (Address[])this.parseAddress(this.to));
            this.subjectLayout = this.makeSubjectLayout(this.subjectStr);
            this.started = true;
        }
        catch (MessagingException e) {
            this.addError("Could not activate SMTPAppender options.", e);
        }
    }

    protected void append(Object eventObject) {
        if (!this.checkEntryConditions()) {
            return;
        }
        this.subAppend(eventObject);
        if (this.evaluator.isTriggeringEvent(null, eventObject)) {
            this.sendBuffer(eventObject);
        }
    }

    protected abstract void subAppend(Object var1);

    public boolean checkEntryConditions() {
        if (this.msg == null) {
            this.addError("Message object not configured.");
            return false;
        }
        if (this.evaluator == null) {
            this.addError("No TriggeringPolicy is set for appender [" + this.name + "].");
            return false;
        }
        if (this.layout == null) {
            this.addError("No layout set for appender named [" + this.name + "]. For more information, please visit http://logback.qos.ch/codes.html#smtp_no_layout");
            return false;
        }
        return true;
    }

    public synchronized void stop() {
        this.started = false;
    }

    InternetAddress getAddress(String addressStr) {
        try {
            return new InternetAddress(addressStr);
        }
        catch (AddressException e) {
            this.addError("Could not parse address [" + addressStr + "].", e);
            return null;
        }
    }

    InternetAddress[] parseAddress(String addressStr) {
        try {
            return InternetAddress.parse((String)addressStr, (boolean)true);
        }
        catch (AddressException e) {
            this.addError("Could not parse address [" + addressStr + "].", e);
            return null;
        }
    }

    public String getTo() {
        return this.to;
    }

    protected void sendBuffer(Object lastEventObject) {
        try {
            MimeBodyPart part = new MimeBodyPart();
            StringBuffer sbuf = new StringBuffer();
            String header = this.layout.getHeader();
            if (header != null) {
                sbuf.append(header);
            }
            this.fillBuffer(sbuf);
            String footer = this.layout.getFooter();
            if (footer != null) {
                sbuf.append(footer);
            }
            if (this.subjectLayout != null) {
                this.msg.setSubject(this.subjectLayout.doLayout(lastEventObject));
            }
            part.setContent((Object)sbuf.toString(), this.layout.getContentType());
            MimeMultipart mp = new MimeMultipart();
            mp.addBodyPart((BodyPart)part);
            this.msg.setContent((Multipart)mp);
            this.msg.setSentDate(new Date());
            Transport.send((Message)this.msg);
        }
        catch (Exception e) {
            this.addError("Error occured while sending e-mail notification.", e);
        }
    }

    protected abstract void fillBuffer(StringBuffer var1);

    public String getEvaluatorClass() {
        return this.evaluator == null ? null : this.evaluator.getClass().getName();
    }

    public String getFrom() {
        return this.from;
    }

    public String getSubject() {
        return this.subjectStr;
    }

    public void setFrom(String from) {
        this.from = from;
    }

    public void setSubject(String subject) {
        this.subjectStr = subject;
    }

    public void setSMTPHost(String smtpHost) {
        this.smtpHost = smtpHost;
    }

    public String getSMTPHost() {
        return this.smtpHost;
    }

    public void setTo(String to) {
        this.to = to;
    }

    public Message getMessage() {
        return this.msg;
    }

    public void setMessage(Message msg) {
        this.msg = msg;
    }

    public void setEvaluator(TriggeringPolicy evaluator) {
        this.evaluator = evaluator;
    }

    public void setEvaluatorClass(String value) {
        try {
            this.evaluator = (TriggeringPolicy)OptionHelper.instantiateByClassName(value, TriggeringPolicy.class);
        }
        catch (Exception ex) {
            this.addError("Evaluator class instanciation failed");
        }
    }

    public Layout getLayout() {
        return this.layout;
    }

    public void setLayout(Layout layout) {
        this.layout = layout;
    }
}

