/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.pattern;

import ch.qos.logback.core.Context;
import ch.qos.logback.core.LayoutBase;
import ch.qos.logback.core.pattern.Converter;
import ch.qos.logback.core.pattern.DynamicConverter;
import ch.qos.logback.core.pattern.parser.Node;
import ch.qos.logback.core.pattern.parser.Parser;
import ch.qos.logback.core.pattern.parser.ScanException;
import ch.qos.logback.core.spi.ContextAware;
import ch.qos.logback.core.status.ErrorStatus;
import ch.qos.logback.core.status.StatusManager;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PatternLayoutBase
extends LayoutBase {
    Converter head;
    String pattern;
    Map<String, String> instanceConverterMap = new HashMap<String, String>();

    public abstract Map<String, String> getDefaultConverterMap();

    public Map<String, String> getEffectiveConverterMap() {
        Map contextMap;
        Context context;
        HashMap<String, String> effectiveMap = new HashMap<String, String>();
        Map<String, String> defaultMap = this.getDefaultConverterMap();
        if (defaultMap != null) {
            effectiveMap.putAll(defaultMap);
        }
        if ((context = this.getContext()) != null && (contextMap = (Map)context.getObject("PATTERN_RULE_REGISTRY")) != null) {
            effectiveMap.putAll(contextMap);
        }
        effectiveMap.putAll(this.instanceConverterMap);
        return effectiveMap;
    }

    @Override
    public void start() {
        try {
            Parser p = new Parser(this.pattern);
            if (this.getContext() != null) {
                p.setStatusManager(this.getContext().getStatusManager());
            }
            Node t = p.parse();
            this.head = p.compile(t, this.getEffectiveConverterMap());
            this.postCompileProcessing(this.head);
            DynamicConverter.startConverters(this.head);
            super.start();
        }
        catch (ScanException sce) {
            StatusManager sm = this.getContext().getStatusManager();
            sm.add(new ErrorStatus("Failed to parse pattern \"" + this.getPattern() + "\".", this, sce));
        }
    }

    protected void postCompileProcessing(Converter head) {
    }

    protected void setContextForConverters(Converter head) {
        Context context = this.getContext();
        for (Converter c = head; c != null; c = c.getNext()) {
            if (!(c instanceof ContextAware)) continue;
            ((ContextAware)((Object)c)).setContext(context);
        }
    }

    protected String writeLoopOnConverters(Object event) {
        StringBuffer buf = new StringBuffer(128);
        for (Converter c = this.head; c != null; c = c.getNext()) {
            c.write(buf, event);
        }
        return buf.toString();
    }

    public String getPattern() {
        return this.pattern;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    public String toString() {
        return this.getClass().getName() + "(" + this.getPattern() + ")";
    }

    protected static Converter findTail(Converter head) {
        Converter next;
        Converter c = head;
        while (c != null && (next = c.getNext()) != null) {
            c = next;
        }
        return c;
    }

    public Map<String, String> getInstanceConverterMap() {
        return this.instanceConverterMap;
    }
}

