/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.rolling;

import ch.qos.logback.core.FileAppender;
import ch.qos.logback.core.rolling.RollingPolicy;
import ch.qos.logback.core.rolling.RolloverFailure;
import ch.qos.logback.core.rolling.TriggeringPolicy;
import java.io.File;
import java.io.IOException;

public class RollingFileAppender
extends FileAppender {
    File activeFileCache;
    TriggeringPolicy triggeringPolicy;
    RollingPolicy rollingPolicy;

    public void start() {
        if (this.triggeringPolicy == null) {
            this.addWarn("No TriggeringPolicy was set for the RollingFileAppender named " + this.getName());
            this.addWarn("For more information, please visit http://logback.qos.ch/codes.html#rfa_no_tp");
            return;
        }
        if (this.rollingPolicy != null) {
            String afn = this.rollingPolicy.getActiveFileName();
            this.activeFileCache = new File(afn);
            this.addInfo("Active log file name: " + afn);
            super.setFile(afn);
            super.start();
        } else {
            this.addWarn("No RollingPolicy was set for the RollingFileAppender named " + this.getName());
            this.addWarn("For more information, please visit http://logback.qos.ch/codes.html#rfa_no_rp");
        }
    }

    public void rollover() {
        this.closeWriter();
        this.append = false;
        try {
            this.rollingPolicy.rollover();
        }
        catch (RolloverFailure rf) {
            this.addWarn("RolloverFailure occurred. Deferring roll-over.");
            this.append = true;
        }
        this.fileName = this.rollingPolicy.getActiveFileName();
        this.addInfo("Active file name is now [" + this.fileName + "].");
        try {
            this.setFile();
        }
        catch (IOException e) {
            this.addError("setFile(" + this.fileName + ", false) call failed.", e);
        }
    }

    protected void subAppend(Object event) {
        if (this.triggeringPolicy.isTriggeringEvent(this.activeFileCache, event)) {
            this.rollover();
        }
        super.subAppend(event);
    }

    public RollingPolicy getRollingPolicy() {
        return this.rollingPolicy;
    }

    public TriggeringPolicy getTriggeringPolicy() {
        return this.triggeringPolicy;
    }

    public void setRollingPolicy(RollingPolicy policy) {
        this.rollingPolicy = policy;
        if (this.rollingPolicy instanceof TriggeringPolicy) {
            this.triggeringPolicy = (TriggeringPolicy)((Object)policy);
        }
    }

    public void setTriggeringPolicy(TriggeringPolicy policy) {
        this.triggeringPolicy = policy;
        if (policy instanceof RollingPolicy) {
            this.rollingPolicy = (RollingPolicy)((Object)policy);
        }
    }

    public void setFile(String filename) {
        throw new UnsupportedOperationException("With RollingFileAppender please use activeFileName option instead of File");
    }
}

