/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.rolling;

import ch.qos.logback.core.rolling.TriggeringPolicyBase;
import java.io.File;

public class SizeBasedTriggeringPolicy
extends TriggeringPolicyBase {
    public static final long DEFAULT_MAX_FILE_SIZE = 0xA00000L;
    String maxFileSize = Long.toString(0xA00000L);
    long maxFileSizeAsLong;

    public SizeBasedTriggeringPolicy() {
    }

    public SizeBasedTriggeringPolicy(String maxFileSize) {
        this.setMaxFileSize(maxFileSize);
    }

    public boolean isTriggeringEvent(File file, Object event) {
        return file.length() >= this.maxFileSizeAsLong;
    }

    public String getMaxFileSize() {
        return this.maxFileSize;
    }

    public void setMaxFileSize(String maxFileSize) {
        this.maxFileSize = maxFileSize;
        this.maxFileSizeAsLong = this.toFileSize(maxFileSize);
    }

    long toFileSize(String value) {
        if (value == null) {
            return 0xA00000L;
        }
        String s = value.trim().toUpperCase();
        long multiplier = 1L;
        int index = s.indexOf("KB");
        if (index != -1) {
            multiplier = 1024L;
            s = s.substring(0, index);
        } else {
            index = s.indexOf("MB");
            if (index != -1) {
                multiplier = 0x100000L;
                s = s.substring(0, index);
            } else {
                index = s.indexOf("GB");
                if (index != -1) {
                    multiplier = 0x40000000L;
                    s = s.substring(0, index);
                }
            }
        }
        if (s != null) {
            try {
                return Long.valueOf(s) * multiplier;
            }
            catch (NumberFormatException e) {
                this.addError("[" + s + "] is not in proper int form. For more info, please visit http://logback.qos.ch/codes.html#sbtp_size_format");
                this.addError("[" + value + "] not in expected format.", e);
            }
        }
        return 0xA00000L;
    }
}

