/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.pattern.parser;

import ch.qos.logback.core.BasicStatusManager;
import ch.qos.logback.core.pattern.Converter;
import ch.qos.logback.core.pattern.Converter123;
import ch.qos.logback.core.pattern.ConverterHello;
import ch.qos.logback.core.pattern.parser.Node;
import ch.qos.logback.core.pattern.parser.Parser;
import ch.qos.logback.core.status.StatusChecker;
import ch.qos.logback.core.status.StatusManager;
import java.util.HashMap;
import java.util.Map;
import junit.framework.TestCase;

public class CompilerTest
extends TestCase {
    Map<String, String> converterMap = new HashMap<String, String>();

    public CompilerTest(String arg0) {
        super(arg0);
        this.converterMap.put("OTT", Converter123.class.getName());
        this.converterMap.put("hello", ConverterHello.class.getName());
    }

    protected void setUp() throws Exception {
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    String write(Converter head, Object event) {
        StringBuffer buf = new StringBuffer();
        for (Converter c = head; c != null; c = c.getNext()) {
            c.write(buf, event);
        }
        return buf.toString();
    }

    public void testLiteral() throws Exception {
        Parser p = new Parser("hello");
        Node t = p.parse();
        Converter head = p.compile(t, this.converterMap);
        String result = this.write(head, new Object());
        CompilerTest.assertEquals((String)"hello", (String)result);
    }

    public void testBasic() throws Exception {
        Parser p = new Parser("abc %hello");
        Node t = p.parse();
        Converter head = p.compile(t, this.converterMap);
        String result = this.write(head, new Object());
        CompilerTest.assertEquals((String)"abc Hello", (String)result);
        p = new Parser("abc %hello %OTT");
        t = p.parse();
        head = p.compile(t, this.converterMap);
        result = this.write(head, new Object());
        CompilerTest.assertEquals((String)"abc Hello 123", (String)result);
    }

    public void testFormat() throws Exception {
        Parser p = new Parser("abc %7hello");
        Node t = p.parse();
        Converter head = p.compile(t, this.converterMap);
        String result = this.write(head, new Object());
        CompilerTest.assertEquals((String)"abc   Hello", (String)result);
        p = new Parser("abc %-7hello");
        t = p.parse();
        head = p.compile(t, this.converterMap);
        result = this.write(head, new Object());
        CompilerTest.assertEquals((String)"abc Hello  ", (String)result);
        p = new Parser("abc %.3hello");
        t = p.parse();
        head = p.compile(t, this.converterMap);
        result = this.write(head, new Object());
        CompilerTest.assertEquals((String)"abc llo", (String)result);
        p = new Parser("abc %.-3hello");
        t = p.parse();
        head = p.compile(t, this.converterMap);
        result = this.write(head, new Object());
        CompilerTest.assertEquals((String)"abc Hel", (String)result);
        p = new Parser("abc %4.5OTT");
        t = p.parse();
        head = p.compile(t, this.converterMap);
        result = this.write(head, new Object());
        CompilerTest.assertEquals((String)"abc  123", (String)result);
        p = new Parser("abc %-4.5OTT");
        t = p.parse();
        head = p.compile(t, this.converterMap);
        result = this.write(head, new Object());
        CompilerTest.assertEquals((String)"abc 123 ", (String)result);
        p = new Parser("abc %3.4hello");
        t = p.parse();
        head = p.compile(t, this.converterMap);
        result = this.write(head, new Object());
        CompilerTest.assertEquals((String)"abc ello", (String)result);
        p = new Parser("abc %-3.-4hello");
        t = p.parse();
        head = p.compile(t, this.converterMap);
        result = this.write(head, new Object());
        CompilerTest.assertEquals((String)"abc Hell", (String)result);
    }

    public void testComposite() throws Exception {
        Parser p = new Parser("%(ABC)");
        Node t = p.parse();
        Converter head = p.compile(t, this.converterMap);
        String result = this.write(head, new Object());
        CompilerTest.assertEquals((String)"ABC", (String)result);
        p = new Parser("%(ABC %hello)");
        t = p.parse();
        head = p.compile(t, this.converterMap);
        result = this.write(head, new Object());
        CompilerTest.assertEquals((String)"ABC Hello", (String)result);
        p = new Parser("%(ABC %hello)");
        t = p.parse();
        head = p.compile(t, this.converterMap);
        result = this.write(head, new Object());
        CompilerTest.assertEquals((String)"ABC Hello", (String)result);
    }

    public void testCompositeFormatting() throws Exception {
        Parser p = new Parser("xyz %4.10(ABC)");
        Node t = p.parse();
        Converter head = p.compile(t, this.converterMap);
        String result = this.write(head, new Object());
        CompilerTest.assertEquals((String)"xyz  ABC", (String)result);
        p = new Parser("xyz %-4.10(ABC)");
        t = p.parse();
        head = p.compile(t, this.converterMap);
        result = this.write(head, new Object());
        CompilerTest.assertEquals((String)"xyz ABC ", (String)result);
        p = new Parser("xyz %.2(ABC %hello)");
        t = p.parse();
        head = p.compile(t, this.converterMap);
        result = this.write(head, new Object());
        CompilerTest.assertEquals((String)"xyz lo", (String)result);
        p = new Parser("xyz %.-2(ABC)");
        t = p.parse();
        head = p.compile(t, this.converterMap);
        result = this.write(head, new Object());
        CompilerTest.assertEquals((String)"xyz AB", (String)result);
        p = new Parser("xyz %30.30(ABC %20hello)");
        t = p.parse();
        head = p.compile(t, this.converterMap);
        result = this.write(head, new Object());
        CompilerTest.assertEquals((String)"xyz       ABC                Hello", (String)result);
    }

    public void testUnknownWord() throws Exception {
        Parser p = new Parser("%unknown");
        BasicStatusManager sm = new BasicStatusManager();
        p.setStatusManager((StatusManager)sm);
        Node t = p.parse();
        p.compile(t, this.converterMap);
        StatusChecker chercker = new StatusChecker((StatusManager)sm);
        CompilerTest.assertTrue((boolean)chercker.containsMatch("\\[unknown] is not a valid conversion word"));
    }

    public void testWithNopEscape() throws Exception {
        Parser p = new Parser("xyz %hello\\_world");
        Node t = p.parse();
        Converter head = p.compile(t, this.converterMap);
        String result = this.write(head, new Object());
        CompilerTest.assertEquals((String)"xyz Helloworld", (String)result);
    }
}

