/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.joran.event;

import ch.qos.logback.core.Context;
import ch.qos.logback.core.ContextBase;
import ch.qos.logback.core.joran.event.BodyEvent;
import ch.qos.logback.core.joran.event.SaxEvent;
import ch.qos.logback.core.joran.event.SaxEventRecorder;
import ch.qos.logback.core.joran.event.StartEvent;
import ch.qos.logback.core.status.StatusManager;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.List;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.xml.sax.Attributes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EventRecorderTest
extends TestCase {
    Context context = new ContextBase();

    public EventRecorderTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    SAXParser createParser() throws Exception {
        SAXParserFactory spf = SAXParserFactory.newInstance();
        return spf.newSAXParser();
    }

    public List<SaxEvent> doTest(String filename) throws Exception {
        SaxEventRecorder recorder = new SaxEventRecorder();
        recorder.setContext(this.context);
        FileInputStream fis = new FileInputStream("src/test/input/joran/" + filename);
        recorder.recordEvents((InputStream)fis);
        return recorder.getSaxEventList();
    }

    public void dump(List<SaxEvent> seList) {
        for (SaxEvent se : seList) {
            System.out.println(se);
        }
    }

    public void test1() throws Exception {
        List<SaxEvent> seList = this.doTest("event1.xml");
        StatusManager sm = this.context.getStatusManager();
        EventRecorderTest.assertTrue((sm.getLevel() == 0 ? 1 : 0) != 0);
        EventRecorderTest.assertEquals((int)11, (int)seList.size());
    }

    public void test2() throws Exception {
        List<SaxEvent> seList = this.doTest("ampEvent.xml");
        StatusManager sm = this.context.getStatusManager();
        EventRecorderTest.assertTrue((sm.getLevel() == 0 ? 1 : 0) != 0);
        EventRecorderTest.assertEquals((int)3, (int)seList.size());
        BodyEvent be = (BodyEvent)seList.get(1);
        EventRecorderTest.assertEquals((String)"xxx & yyy", (String)be.getText());
    }

    public void test3() throws Exception {
        List<SaxEvent> seList = this.doTest("inc.xml");
        StatusManager sm = this.context.getStatusManager();
        EventRecorderTest.assertTrue((sm.getLevel() == 0 ? 1 : 0) != 0);
        EventRecorderTest.assertEquals((int)4, (int)seList.size());
        StartEvent se = (StartEvent)seList.get(1);
        Attributes attr = se.getAttributes();
        EventRecorderTest.assertNotNull((Object)attr);
        EventRecorderTest.assertEquals((String)"1", (String)attr.getValue("increment"));
    }

    public static Test XXXsuite() {
        TestSuite suite = new TestSuite();
        suite.addTest((Test)new EventRecorderTest("test2"));
        return suite;
    }
}

