/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.joran.spi;

import ch.qos.logback.core.joran.spi.Pattern;
import junit.framework.TestCase;

public class PatternTest
extends TestCase {
    public PatternTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void test1() {
        Pattern p = new Pattern("a");
        PatternTest.assertEquals((int)1, (int)p.size());
        PatternTest.assertEquals((String)"a", (String)p.peekLast());
        PatternTest.assertEquals((String)"a", (String)p.get(0));
    }

    public void testSuffix() {
        Pattern p = new Pattern("a/");
        PatternTest.assertEquals((int)1, (int)p.size());
        PatternTest.assertEquals((String)"a", (String)p.peekLast());
        PatternTest.assertEquals((String)"a", (String)p.get(0));
    }

    public void test2() {
        Pattern p = new Pattern("a/b");
        PatternTest.assertEquals((int)2, (int)p.size());
        PatternTest.assertEquals((String)"b", (String)p.peekLast());
        PatternTest.assertEquals((String)"a", (String)p.get(0));
        PatternTest.assertEquals((String)"b", (String)p.get(1));
    }

    public void test3() {
        Pattern p = new Pattern("a123/b1234/cvvsdf");
        PatternTest.assertEquals((int)3, (int)p.size());
        PatternTest.assertEquals((String)"a123", (String)p.get(0));
        PatternTest.assertEquals((String)"b1234", (String)p.get(1));
        PatternTest.assertEquals((String)"cvvsdf", (String)p.get(2));
    }

    public void test4() {
        Pattern p = new Pattern("/a123/b1234/cvvsdf");
        PatternTest.assertEquals((int)3, (int)p.size());
        PatternTest.assertEquals((String)"a123", (String)p.get(0));
        PatternTest.assertEquals((String)"b1234", (String)p.get(1));
        PatternTest.assertEquals((String)"cvvsdf", (String)p.get(2));
    }

    public void test5() {
        Pattern p = new Pattern("//a");
        PatternTest.assertEquals((int)1, (int)p.size());
        PatternTest.assertEquals((String)"a", (String)p.get(0));
    }

    public void test6() {
        Pattern p = new Pattern("//a//b");
        PatternTest.assertEquals((int)2, (int)p.size());
        PatternTest.assertEquals((String)"a", (String)p.get(0));
        PatternTest.assertEquals((String)"b", (String)p.get(1));
    }

    public void testTailMatch() {
        Pattern p = new Pattern("/a/b");
        Pattern rulePattern = new Pattern("*");
        PatternTest.assertEquals((int)0, (int)p.getTailMatchLength(rulePattern));
        p = new Pattern("/a");
        rulePattern = new Pattern("*/a");
        PatternTest.assertEquals((int)1, (int)p.getTailMatchLength(rulePattern));
        p = new Pattern("/a/b");
        rulePattern = new Pattern("*/b");
        PatternTest.assertEquals((int)1, (int)p.getTailMatchLength(rulePattern));
        p = new Pattern("/a/b/c");
        rulePattern = new Pattern("*/b/c");
        PatternTest.assertEquals((int)2, (int)p.getTailMatchLength(rulePattern));
    }

    public void testPrefixMatch() {
        Pattern p = new Pattern("/a/b");
        Pattern rulePattern = new Pattern("/x/*");
        PatternTest.assertEquals((int)0, (int)p.getPrefixMatchLength(rulePattern));
        p = new Pattern("/a");
        rulePattern = new Pattern("/x/*");
        PatternTest.assertEquals((int)0, (int)p.getPrefixMatchLength(rulePattern));
        p = new Pattern("/a/b");
        rulePattern = new Pattern("/a/*");
        PatternTest.assertEquals((int)1, (int)p.getPrefixMatchLength(rulePattern));
        p = new Pattern("/a/b");
        rulePattern = new Pattern("/a/b/*");
        PatternTest.assertEquals((int)2, (int)p.getPrefixMatchLength(rulePattern));
        p = new Pattern("/a/b");
        rulePattern = new Pattern("/*");
        PatternTest.assertEquals((int)0, (int)p.getPrefixMatchLength(rulePattern));
    }
}

