/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core;

import ch.qos.logback.core.Appender;
import ch.qos.logback.core.Layout;
import ch.qos.logback.core.filter.Filter;
import ch.qos.logback.core.spi.ContextAwareBase;
import ch.qos.logback.core.spi.FilterAttachable;
import ch.qos.logback.core.spi.FilterAttachableImpl;
import ch.qos.logback.core.spi.FilterReply;
import ch.qos.logback.core.status.WarnStatus;

public abstract class AppenderBase
extends ContextAwareBase
implements Appender,
FilterAttachable {
    protected boolean started = false;
    private boolean guard = false;
    protected String name;
    private FilterAttachableImpl fai = new FilterAttachableImpl();
    private int statusRepeatCount = 0;
    private int exceptionCount = 0;
    static final int ALLOWED_REPEATS = 5;

    public String getName() {
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void doAppend(Object eventObject) {
        if (this.guard) {
            return;
        }
        try {
            this.guard = true;
            if (!this.started) {
                if (this.statusRepeatCount++ < 5) {
                    this.addStatus(new WarnStatus("Attempted to append to non started appender [" + this.name + "].", this));
                }
                return;
            }
            if (this.getFilterChainDecision(eventObject) == FilterReply.DENY) {
                return;
            }
            this.append(eventObject);
        }
        catch (Exception e) {
            if (this.exceptionCount++ < 5) {
                this.addError("Appender [" + this.name + "] failed to append.", e);
            }
        }
        finally {
            this.guard = false;
        }
    }

    protected abstract void append(Object var1);

    public void setName(String name) {
        this.name = name;
    }

    public void start() {
        this.started = true;
    }

    public void stop() {
        this.started = false;
    }

    public boolean isStarted() {
        return this.started;
    }

    public String toString() {
        return this.getClass().getName() + "[" + this.name + "]";
    }

    public void addFilter(Filter newFilter) {
        this.fai.addFilter(newFilter);
    }

    public Filter getFirstFilter() {
        return this.fai.getFirstFilter();
    }

    public void clearAllFilters() {
        this.fai.clearAllFilters();
    }

    public FilterReply getFilterChainDecision(Object event) {
        return this.fai.getFilterChainDecision(event);
    }

    public Layout getLayout() {
        return null;
    }

    public void setLayout(Layout layout) {
    }
}

