/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.filter;

import ch.qos.logback.core.boolex.EvaluationException;
import ch.qos.logback.core.boolex.EventEvaluator;
import ch.qos.logback.core.filter.Filter;
import ch.qos.logback.core.spi.FilterReply;

public class EvaluatorFilter
extends Filter {
    EventEvaluator evaluator;
    protected FilterReply onMatch = FilterReply.NEUTRAL;
    protected FilterReply onMismatch = FilterReply.NEUTRAL;

    public final void setOnMatch(String action) {
        if ("NEUTRAL".equals(action)) {
            this.onMatch = FilterReply.NEUTRAL;
        } else if ("ACCEPT".equals(action)) {
            this.onMatch = FilterReply.ACCEPT;
        } else if ("DENY".equals(action)) {
            this.onMatch = FilterReply.DENY;
        }
    }

    public final void setOnMismatch(String action) {
        if ("NEUTRAL".equals(action)) {
            this.onMismatch = FilterReply.NEUTRAL;
        } else if ("ACCEPT".equals(action)) {
            this.onMismatch = FilterReply.ACCEPT;
        } else if ("DENY".equals(action)) {
            this.onMismatch = FilterReply.DENY;
        }
    }

    public void start() {
        if (this.evaluator != null) {
            super.start();
        } else {
            this.addError("No evaluator set for filter " + this.getName());
        }
    }

    public EventEvaluator getEvaluator() {
        return this.evaluator;
    }

    public void setEvaluator(EventEvaluator evaluator) {
        this.evaluator = evaluator;
    }

    public FilterReply decide(Object event) {
        if (!this.isStarted()) {
            return FilterReply.NEUTRAL;
        }
        try {
            if (this.evaluator.evaluate(event)) {
                return this.onMatch;
            }
            return this.onMismatch;
        }
        catch (EvaluationException e) {
            this.addError("Evaluator " + this.evaluator.getName() + " threw an exception", e);
            return FilterReply.NEUTRAL;
        }
    }
}

