/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.rolling;

import ch.qos.logback.core.rolling.RollingPolicyBase;
import ch.qos.logback.core.rolling.RolloverFailure;
import ch.qos.logback.core.rolling.TriggeringPolicy;
import ch.qos.logback.core.rolling.helper.Compress;
import ch.qos.logback.core.rolling.helper.DateTokenConverter;
import ch.qos.logback.core.rolling.helper.FileNamePattern;
import ch.qos.logback.core.rolling.helper.RenameUtil;
import ch.qos.logback.core.rolling.helper.RollingCalendar;
import java.io.File;
import java.util.Date;

public class TimeBasedRollingPolicy
extends RollingPolicyBase
implements TriggeringPolicy {
    static final String FNP_NOT_SET = "The FileNamePattern option must be set before using TimeBasedRollingPolicy. ";
    static final String SEE_FNP_NOT_SET = "See also http://logback.qos.ch/codes.html#tbr_fnp_not_set";
    RollingCalendar rc;
    long nextCheck;
    Date lastCheck = new Date();
    String elapsedPeriodsFileName;
    FileNamePattern activeFileNamePattern;
    RenameUtil util = new RenameUtil();
    Compress compress = new Compress();
    String lastGeneratedFileName;

    public void start() {
        this.util.setContext(this.context);
        this.compress.setContext(this.context);
        if (this.fileNamePatternStr == null) {
            this.addWarn(FNP_NOT_SET);
            this.addWarn(SEE_FNP_NOT_SET);
            throw new IllegalStateException("The FileNamePattern option must be set before using TimeBasedRollingPolicy. See also http://logback.qos.ch/codes.html#tbr_fnp_not_set");
        }
        this.fileNamePattern = new FileNamePattern(this.fileNamePatternStr, this.context);
        this.determineCompressionMode();
        DateTokenConverter dtc = this.fileNamePattern.getDateTokenConverter();
        if (dtc == null) {
            throw new IllegalStateException("FileNamePattern [" + this.fileNamePattern.getPattern() + "] does not contain a valid DateToken");
        }
        int len = this.fileNamePatternStr.length();
        switch (this.compressionMode) {
            case 1: {
                this.activeFileNamePattern = new FileNamePattern(this.fileNamePatternStr.substring(0, len - 3), this.context);
                break;
            }
            case 2: {
                this.activeFileNamePattern = new FileNamePattern(this.fileNamePatternStr.substring(0, len - 4), this.context);
                break;
            }
            case 0: {
                this.activeFileNamePattern = this.fileNamePattern;
            }
        }
        this.addInfo("Will use the pattern " + this.activeFileNamePattern + " for the active file");
        this.rc = new RollingCalendar();
        this.rc.init(dtc.getDatePattern());
        this.addInfo("The date pattern is '" + dtc.getDatePattern() + "' from file name pattern '" + this.fileNamePattern.getPattern() + "'.");
        this.rc.printPeriodicity(this);
        long n = System.currentTimeMillis();
        this.lastCheck.setTime(n);
        this.nextCheck = this.rc.getNextCheckMillis(this.lastCheck);
    }

    public void rollover() throws RolloverFailure {
        if (this.getParentFileName() == null) {
            switch (this.compressionMode) {
                case 0: {
                    break;
                }
                case 1: {
                    this.addInfo("GZIP compressing [" + this.elapsedPeriodsFileName + "].");
                    this.compress.GZCompress(this.elapsedPeriodsFileName);
                    break;
                }
                case 2: {
                    this.addInfo("ZIP compressing [" + this.elapsedPeriodsFileName + "]");
                    this.compress.ZIPCompress(this.elapsedPeriodsFileName);
                }
            }
        } else {
            switch (this.compressionMode) {
                case 0: {
                    this.util.rename(this.getParentFileName(), this.elapsedPeriodsFileName);
                    break;
                }
                case 1: {
                    this.addInfo("GZIP compressing [" + this.elapsedPeriodsFileName + "]");
                    this.compress.GZCompress(this.getParentFileName(), this.elapsedPeriodsFileName);
                    break;
                }
                case 2: {
                    this.addInfo("ZIP compressing [" + this.elapsedPeriodsFileName + "]");
                    this.compress.ZIPCompress(this.getParentFileName(), this.elapsedPeriodsFileName);
                }
            }
        }
        this.setParentFileName(this.getNewActiveFileName());
    }

    public String getNewActiveFileName() {
        if (this.getParentFileName() == null || this.getParentFileName() == this.lastGeneratedFileName) {
            String newName = this.activeFileNamePattern.convertDate(this.lastCheck);
            this.addInfo("Generated a new name for RollingFileAppender: " + newName);
            this.lastGeneratedFileName = newName;
            return newName;
        }
        return this.getParentFileName();
    }

    public boolean isTriggeringEvent(File activeFile, Object event) {
        long n = System.currentTimeMillis();
        if (n >= this.nextCheck) {
            this.elapsedPeriodsFileName = this.activeFileNamePattern.convertDate(this.lastCheck);
            this.lastCheck.setTime(n);
            this.nextCheck = this.rc.getNextCheckMillis(this.lastCheck);
            Date x = new Date();
            x.setTime(this.nextCheck);
            return true;
        }
        return false;
    }

    public String toString() {
        return "c.q.l.core.rolling.TimeBasedRollingPolicy";
    }
}

