/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.rolling;

import ch.qos.logback.core.Context;
import ch.qos.logback.core.ContextBase;
import ch.qos.logback.core.FileAppender;
import ch.qos.logback.core.Layout;
import ch.qos.logback.core.layout.DummyLayout;
import ch.qos.logback.core.rolling.FixedWindowRollingPolicy;
import ch.qos.logback.core.rolling.RollingFileAppender;
import ch.qos.logback.core.rolling.RollingPolicy;
import ch.qos.logback.core.rolling.SizeBasedTriggeringPolicy;
import ch.qos.logback.core.rolling.TriggeringPolicy;
import ch.qos.logback.core.util.Compare;
import java.io.File;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class SizeBasedRollingTest
extends TestCase {
    public SizeBasedRollingTest(String name) {
        super(name);
    }

    public void setUp() {
        File target = new File("src/test/output/sizeBased-test2.log");
        target.mkdirs();
        target.delete();
        target = new File("src/test/output/sbr-test3.log");
        target.mkdirs();
        target.delete();
    }

    public void tearDown() {
    }

    public void test1() throws Exception {
        ContextBase context = new ContextBase();
        DummyLayout layout = new DummyLayout();
        RollingFileAppender rfa = new RollingFileAppender();
        rfa.setLayout((Layout)layout);
        rfa.setContext((Context)new ContextBase());
        FixedWindowRollingPolicy fwrp = new FixedWindowRollingPolicy();
        fwrp.setContext((Context)context);
        fwrp.setParent((FileAppender)rfa);
        SizeBasedTriggeringPolicy sbtp = new SizeBasedTriggeringPolicy();
        sbtp.setContext((Context)context);
        sbtp.setMaxFileSize("100");
        sbtp.start();
        fwrp.setFileNamePattern("src/test/output/sizeBased-test1.%i");
        try {
            fwrp.start();
            SizeBasedRollingTest.fail((String)"The absence of activeFileName option should have caused an exception.");
        }
        catch (IllegalStateException e) {
            return;
        }
    }

    public void test2() throws Exception {
        ContextBase context = new ContextBase();
        DummyLayout layout = new DummyLayout();
        RollingFileAppender rfa = new RollingFileAppender();
        rfa.setName("ROLLING");
        rfa.setLayout((Layout)layout);
        rfa.setContext((Context)context);
        rfa.setFile("src/test/output/sizeBased-test2.log");
        FixedWindowRollingPolicy swrp = new FixedWindowRollingPolicy();
        swrp.setContext((Context)context);
        SizeBasedTriggeringPolicy sbtp = new SizeBasedTriggeringPolicy();
        sbtp.setContext((Context)context);
        sbtp.setMaxFileSize("100");
        swrp.setMinIndex(0);
        swrp.setFileNamePattern("src/test/output/sizeBased-test2.%i");
        swrp.setParent((FileAppender)rfa);
        swrp.start();
        rfa.setRollingPolicy((RollingPolicy)swrp);
        rfa.setTriggeringPolicy((TriggeringPolicy)sbtp);
        rfa.start();
        for (int i = 0; i < 45; ++i) {
            Thread.sleep(10L);
            rfa.doAppend((Object)"hello");
        }
        SizeBasedRollingTest.assertTrue((boolean)new File("src/test/output/sizeBased-test2.log").exists());
        SizeBasedRollingTest.assertTrue((boolean)new File("src/test/output/sizeBased-test2.0").exists());
        SizeBasedRollingTest.assertTrue((boolean)new File("src/test/output/sizeBased-test2.1").exists());
        if (!this.isWindows()) {
            SizeBasedRollingTest.assertTrue((boolean)Compare.compare("src/test/output/sizeBased-test2.log", "src/test/witness/rolling/sbr-test2.l"));
            SizeBasedRollingTest.assertTrue((boolean)Compare.compare("src/test/output/sizeBased-test2.0", "src/test/witness/rolling/sbr-test2.0"));
            SizeBasedRollingTest.assertTrue((boolean)Compare.compare("src/test/output/sizeBased-test2.1", "src/test/witness/rolling/sbr-test2.1"));
        }
    }

    public void test3() throws Exception {
        ContextBase context = new ContextBase();
        DummyLayout layout = new DummyLayout();
        RollingFileAppender rfa = new RollingFileAppender();
        rfa.setLayout((Layout)layout);
        rfa.setContext((Context)context);
        rfa.setFile("src/test/output/sbr-test3.log");
        FixedWindowRollingPolicy fwrp = new FixedWindowRollingPolicy();
        fwrp.setContext((Context)context);
        SizeBasedTriggeringPolicy sbtp = new SizeBasedTriggeringPolicy();
        sbtp.setContext((Context)context);
        sbtp.setMaxFileSize("100");
        fwrp.setMinIndex(0);
        fwrp.setFileNamePattern("src/test/output/sbr-test3.%i.gz");
        fwrp.setParent((FileAppender)rfa);
        fwrp.start();
        rfa.setRollingPolicy((RollingPolicy)fwrp);
        rfa.setTriggeringPolicy((TriggeringPolicy)sbtp);
        rfa.start();
        for (int i = 0; i < 45; ++i) {
            Thread.sleep(10L);
            rfa.doAppend((Object)"hello");
        }
        SizeBasedRollingTest.assertTrue((boolean)new File("src/test/output/sbr-test3.log").exists());
        SizeBasedRollingTest.assertTrue((boolean)new File("src/test/output/sbr-test3.0.gz").exists());
        SizeBasedRollingTest.assertTrue((boolean)new File("src/test/output/sbr-test3.1.gz").exists());
        if (!this.isWindows()) {
            SizeBasedRollingTest.assertTrue((boolean)Compare.compare("Constants.TEST_DIR_PREFIXoutput/sbr-test3.log", "src/test/witness/rolling/sbr-test3.l"));
            SizeBasedRollingTest.assertTrue((boolean)Compare.gzCompare("Constants.TEST_DIR_PREFIXoutput/sbr-test3.0.gz", "src/test/witness/rolling/sbr-test3.0.gz"));
            SizeBasedRollingTest.assertTrue((boolean)Compare.gzCompare("Constants.TEST_DIR_PREFIXoutput/sbr-test3.1.gz", "src/test/witness/rolling/sbr-test3.1.gz"));
        }
    }

    boolean isWindows() {
        return System.getProperty("os.name").indexOf("Windows") != -1;
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.addTestSuite(SizeBasedRollingTest.class);
        return suite;
    }
}

