/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.rolling;

import ch.qos.logback.core.Context;
import ch.qos.logback.core.ContextBase;
import ch.qos.logback.core.FileAppender;
import ch.qos.logback.core.Layout;
import ch.qos.logback.core.layout.EchoLayout;
import ch.qos.logback.core.rolling.DelayerUtil;
import ch.qos.logback.core.rolling.RollingFileAppender;
import ch.qos.logback.core.rolling.RollingPolicy;
import ch.qos.logback.core.rolling.TimeBasedRollingPolicy;
import ch.qos.logback.core.util.Compare;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TimeBasedRollingTest
extends TestCase {
    static final String DATE_PATTERN = "yyyy-MM-dd_HH_mm_ss";
    EchoLayout layout = new EchoLayout();
    Context context = new ContextBase();

    public TimeBasedRollingTest(String name) {
        super(name);
    }

    public void setUp() {
        this.context.setName("test");
        File target = new File("src/test/output/test4.log");
        target.mkdirs();
        target.delete();
        target = new File("src/test/output/test5.log");
        target.mkdirs();
        target.delete();
        target = new File("src/test/output/test6.log");
        target.mkdirs();
        target.delete();
    }

    public void tearDown() {
    }

    public void test1() throws Exception {
        int i;
        RollingFileAppender rfa = new RollingFileAppender();
        rfa.setContext(this.context);
        rfa.setLayout((Layout)this.layout);
        TimeBasedRollingPolicy tbrp = new TimeBasedRollingPolicy();
        tbrp.setContext(this.context);
        tbrp.setFileNamePattern("src/test/output/test1-%d{yyyy-MM-dd_HH_mm_ss}");
        tbrp.setParent((FileAppender)rfa);
        tbrp.start();
        rfa.setRollingPolicy((RollingPolicy)tbrp);
        rfa.start();
        SimpleDateFormat sdf = new SimpleDateFormat(DATE_PATTERN);
        String[] filenames = new String[3];
        Calendar cal = Calendar.getInstance();
        for (i = 0; i < 3; ++i) {
            filenames[i] = "src/test/output/test1-" + sdf.format(cal.getTime());
            cal.add(13, 1);
        }
        DelayerUtil.delayUntilNextSecond(100);
        for (i = 0; i < 3; ++i) {
            rfa.doAppend((Object)("Hello---" + i));
            Thread.sleep(500L);
        }
        for (i = 0; i < 3; ++i) {
            TimeBasedRollingTest.assertTrue((boolean)Compare.compare(filenames[i], "src/test/witness/rolling/tbr-test1." + i));
        }
    }

    public void test2() throws Exception {
        int i;
        int i2;
        RollingFileAppender rfa1 = new RollingFileAppender();
        rfa1.setContext(this.context);
        rfa1.setLayout((Layout)this.layout);
        TimeBasedRollingPolicy tbrp1 = new TimeBasedRollingPolicy();
        tbrp1.setFileNamePattern("src/test/output/test2-%d{yyyy-MM-dd_HH_mm_ss}");
        tbrp1.setContext(this.context);
        tbrp1.setParent((FileAppender)rfa1);
        tbrp1.start();
        rfa1.setRollingPolicy((RollingPolicy)tbrp1);
        rfa1.start();
        SimpleDateFormat sdf = new SimpleDateFormat(DATE_PATTERN);
        String[] filenames = new String[3];
        Calendar cal = Calendar.getInstance();
        for (i2 = 0; i2 < 3; ++i2) {
            filenames[i2] = "src/test/output/test2-" + sdf.format(cal.getTime());
            cal.add(13, 1);
        }
        DelayerUtil.delayUntilNextSecond(100);
        for (i2 = 0; i2 <= 2; ++i2) {
            rfa1.doAppend((Object)("Hello---" + i2));
            Thread.sleep(500L);
        }
        rfa1.stop();
        RollingFileAppender rfa2 = new RollingFileAppender();
        rfa2.setContext(this.context);
        rfa2.setLayout((Layout)this.layout);
        TimeBasedRollingPolicy tbrp2 = new TimeBasedRollingPolicy();
        tbrp2.setContext(this.context);
        tbrp2.setFileNamePattern("src/test/output/test2-%d{yyyy-MM-dd_HH_mm_ss}");
        tbrp2.setParent((FileAppender)rfa2);
        tbrp2.start();
        rfa2.setRollingPolicy((RollingPolicy)tbrp2);
        rfa2.start();
        for (i = 0; i <= 2; ++i) {
            rfa2.doAppend((Object)("Hello---" + i));
            Thread.sleep(100L);
        }
        for (i = 0; i < 3; ++i) {
            TimeBasedRollingTest.assertTrue((boolean)Compare.compare(filenames[i], "src/test/witness/rolling/tbr-test2." + i));
        }
    }

    public void test3() throws Exception {
        int i;
        RollingFileAppender rfa = new RollingFileAppender();
        rfa.setContext(this.context);
        rfa.setLayout((Layout)this.layout);
        TimeBasedRollingPolicy tbrp = new TimeBasedRollingPolicy();
        tbrp.setContext(this.context);
        tbrp.setFileNamePattern("src/test/output/test3-%d{yyyy-MM-dd_HH_mm_ss}.gz");
        tbrp.setParent((FileAppender)rfa);
        tbrp.start();
        rfa.setRollingPolicy((RollingPolicy)tbrp);
        rfa.start();
        SimpleDateFormat sdf = new SimpleDateFormat(DATE_PATTERN);
        String[] filenames = new String[4];
        Calendar cal = Calendar.getInstance();
        for (i = 0; i < 2; ++i) {
            filenames[i] = "src/test/output/test3-" + sdf.format(cal.getTime()) + ".gz";
            cal.add(13, 1);
        }
        filenames[3] = "src/test/output/test3-" + sdf.format(cal.getTime());
        DelayerUtil.delayUntilNextSecond(100);
        for (i = 0; i < 3; ++i) {
            rfa.doAppend((Object)("Hello---" + i));
            Thread.sleep(500L);
        }
        for (i = 0; i < 2; ++i) {
            TimeBasedRollingTest.assertTrue((boolean)Compare.gzCompare(filenames[i], "src/test/witness/rolling/tbr-test3." + i + ".gz"));
        }
        TimeBasedRollingTest.assertTrue((boolean)Compare.compare(filenames[3], "src/test/witness/rolling/tbr-test3.2"));
    }

    public void test4() throws Exception {
        int i;
        int i2;
        RollingFileAppender rfa1 = new RollingFileAppender();
        rfa1.setContext(this.context);
        rfa1.setLayout((Layout)this.layout);
        rfa1.setFile("src/test/output/test4.log");
        TimeBasedRollingPolicy tbrp1 = new TimeBasedRollingPolicy();
        tbrp1.setContext(this.context);
        tbrp1.setFileNamePattern("src/test/output/test4-%d{yyyy-MM-dd_HH_mm_ss}");
        tbrp1.setParent((FileAppender)rfa1);
        tbrp1.start();
        rfa1.setRollingPolicy((RollingPolicy)tbrp1);
        rfa1.start();
        SimpleDateFormat sdf = new SimpleDateFormat(DATE_PATTERN);
        String[] filenames = new String[3];
        Calendar cal = Calendar.getInstance();
        for (i2 = 0; i2 < 2; ++i2) {
            filenames[i2] = "src/test/output/test4-" + sdf.format(cal.getTime());
            cal.add(13, 1);
        }
        filenames[2] = "src/test/output/test4.log";
        DelayerUtil.delayUntilNextSecond(50);
        for (i2 = 0; i2 <= 2; ++i2) {
            rfa1.doAppend((Object)("Hello---" + i2));
            Thread.sleep(500L);
        }
        rfa1.stop();
        RollingFileAppender rfa2 = new RollingFileAppender();
        rfa2.setContext(this.context);
        rfa2.setLayout((Layout)this.layout);
        rfa2.setFile("src/test/output/test4.log");
        TimeBasedRollingPolicy tbrp2 = new TimeBasedRollingPolicy();
        tbrp2.setContext(this.context);
        tbrp2.setFileNamePattern("src/test/output/test4-%d{yyyy-MM-dd_HH_mm_ss}");
        tbrp2.setParent((FileAppender)rfa2);
        tbrp2.start();
        rfa2.setRollingPolicy((RollingPolicy)tbrp2);
        rfa2.start();
        for (i = 0; i <= 2; ++i) {
            rfa2.doAppend((Object)("Hello---" + i));
            Thread.sleep(100L);
        }
        for (i = 0; i < 3; ++i) {
            TimeBasedRollingTest.assertTrue((boolean)Compare.compare(filenames[i], "src/test/witness/rolling/tbr-test4." + i));
        }
    }

    public void test5() throws Exception {
        int i;
        RollingFileAppender rfa = new RollingFileAppender();
        rfa.setContext(this.context);
        rfa.setLayout((Layout)this.layout);
        rfa.setFile("src/test/output/test5.log");
        TimeBasedRollingPolicy tbrp = new TimeBasedRollingPolicy();
        tbrp.setContext(this.context);
        tbrp.setFileNamePattern("src/test/output/test5-%d{yyyy-MM-dd_HH_mm_ss}");
        tbrp.setParent((FileAppender)rfa);
        tbrp.start();
        rfa.setRollingPolicy((RollingPolicy)tbrp);
        rfa.start();
        SimpleDateFormat sdf = new SimpleDateFormat(DATE_PATTERN);
        String[] filenames = new String[4];
        Calendar cal = Calendar.getInstance();
        for (i = 0; i < 2; ++i) {
            filenames[i] = "src/test/output/test5-" + sdf.format(cal.getTime());
            cal.add(13, 1);
        }
        filenames[2] = "src/test/output/test5.log";
        DelayerUtil.delayUntilNextSecond(100);
        for (i = 0; i < 3; ++i) {
            rfa.doAppend((Object)("Hello---" + i));
            Thread.sleep(500L);
        }
        for (i = 0; i < 3; ++i) {
            TimeBasedRollingTest.assertTrue((boolean)Compare.compare(filenames[i], "src/test/witness/rolling/tbr-test5." + i));
        }
    }

    public void test6() throws Exception {
        int i;
        RollingFileAppender rfa = new RollingFileAppender();
        rfa.setContext(this.context);
        rfa.setLayout((Layout)this.layout);
        rfa.setFile("src/test/output/test6.log");
        TimeBasedRollingPolicy tbrp = new TimeBasedRollingPolicy();
        tbrp.setContext(this.context);
        tbrp.setFileNamePattern("src/test/output/test6-%d{yyyy-MM-dd_HH_mm_ss}.gz");
        tbrp.setParent((FileAppender)rfa);
        tbrp.start();
        rfa.setRollingPolicy((RollingPolicy)tbrp);
        rfa.start();
        SimpleDateFormat sdf = new SimpleDateFormat(DATE_PATTERN);
        String[] filenames = new String[4];
        Calendar cal = Calendar.getInstance();
        for (i = 0; i < 2; ++i) {
            filenames[i] = "src/test/output/test6-" + sdf.format(cal.getTime()) + ".gz";
            cal.add(13, 1);
        }
        filenames[2] = "src/test/output/test6.log";
        DelayerUtil.delayUntilNextSecond(100);
        for (i = 0; i < 3; ++i) {
            rfa.doAppend((Object)("Hello---" + i));
            Thread.sleep(500L);
        }
        for (i = 0; i < 2; ++i) {
            TimeBasedRollingTest.assertTrue((boolean)Compare.gzCompare(filenames[i], "src/test/witness/rolling/tbr-test6." + i + ".gz"));
        }
        TimeBasedRollingTest.assertTrue((boolean)Compare.compare(filenames[2], "src/test/witness/rolling/tbr-test6.2"));
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.addTestSuite(TimeBasedRollingTest.class);
        return suite;
    }
}

