/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.pattern.parser;

import ch.qos.logback.core.pattern.Converter;
import ch.qos.logback.core.pattern.FormatInfo;
import ch.qos.logback.core.pattern.parser.Compiler;
import ch.qos.logback.core.pattern.parser.CompositeNode;
import ch.qos.logback.core.pattern.parser.FormattingNode;
import ch.qos.logback.core.pattern.parser.KeywordNode;
import ch.qos.logback.core.pattern.parser.Node;
import ch.qos.logback.core.pattern.parser.OptionTokenizer;
import ch.qos.logback.core.pattern.parser.ScanException;
import ch.qos.logback.core.pattern.parser.Token;
import ch.qos.logback.core.pattern.parser.TokenStream;
import ch.qos.logback.core.status.StatusManager;
import java.util.List;
import java.util.Map;

public class Parser {
    StatusManager statusManager;
    final List tokenList;
    int pointer = 0;

    Parser(TokenStream ts) throws ScanException {
        this.tokenList = ts.tokenize();
    }

    public Parser(String pattern) throws ScanException {
        try {
            TokenStream ts = new TokenStream(pattern);
            this.tokenList = ts.tokenize();
        }
        catch (NullPointerException npe) {
            throw new ScanException("Failed to initialize Parser", npe);
        }
    }

    public Node parse() throws ScanException {
        return this.E();
    }

    public Converter compile(Node top, Map converterMap) {
        Compiler compiler = new Compiler(top, converterMap);
        compiler.setStatusManager(this.statusManager);
        return compiler.compile();
    }

    Node E() throws ScanException {
        Node t = this.T();
        if (t == null) {
            return null;
        }
        Node eOpt = this.Eopt();
        if (eOpt != null) {
            t.setNext(eOpt);
        }
        return t;
    }

    Node T() throws ScanException {
        Token t = this.getCurentToken();
        if (t == null) {
            throw new IllegalStateException("a LITERAL or '%'");
        }
        switch (t.getType()) {
            case 1000: {
                this.advanceTokenPointer();
                return new Node(0, t.getValue());
            }
            case 37: {
                FormattingNode c;
                this.advanceTokenPointer();
                Token u = this.getCurentToken();
                this.expectNotNull(u, "a FORMAT_MODIFIER, KEYWORD or LEFT_PARENTHESIS");
                if (u.getType() == 1002) {
                    FormatInfo fi = FormatInfo.valueOf((String)u.getValue());
                    this.advanceTokenPointer();
                    c = this.C();
                    c.setFormatInfo(fi);
                } else {
                    c = this.C();
                }
                return c;
            }
        }
        return null;
    }

    Node Eopt() throws ScanException {
        Token next = this.getCurentToken();
        if (next == null) {
            return null;
        }
        return this.E();
    }

    FormattingNode C() throws ScanException {
        Token t = this.getCurentToken();
        this.expectNotNull(t, "a LEFT_PARENTHESIS or KEYWORD");
        int type = t.getType();
        switch (type) {
            case 1004: {
                return this.SINGLE();
            }
            case 40: {
                this.advanceTokenPointer();
                return this.COMPOSITE();
            }
        }
        throw new IllegalStateException("Unexpected token " + t);
    }

    FormattingNode SINGLE() throws ScanException {
        Token t = this.getNextToken();
        KeywordNode keywordNode = new KeywordNode(t.getValue());
        Token ot = this.getCurentToken();
        if (ot != null && ot.getType() == 1006) {
            List optionList = new OptionTokenizer((String)ot.getValue()).tokenize();
            keywordNode.setOptions(optionList);
            this.advanceTokenPointer();
        }
        return keywordNode;
    }

    FormattingNode COMPOSITE() throws ScanException {
        CompositeNode compositeNode = new CompositeNode();
        Node childNode = this.E();
        compositeNode.setChildNode(childNode);
        Token t = this.getNextToken();
        if (t.getType() != 41) {
            throw new IllegalStateException("Expecting RIGHT_PARENTHESIS token but got " + t);
        }
        return compositeNode;
    }

    Token getNextToken() {
        if (this.pointer < this.tokenList.size()) {
            return (Token)this.tokenList.get(this.pointer++);
        }
        return null;
    }

    Token getCurentToken() {
        if (this.pointer < this.tokenList.size()) {
            return (Token)this.tokenList.get(this.pointer);
        }
        return null;
    }

    void advanceTokenPointer() {
        ++this.pointer;
    }

    void expectNotNull(Token t, String expected) {
        if (t == null) {
            throw new IllegalStateException("All tokens consumed but was expecting " + expected);
        }
    }

    public void setStatusManager(StatusManager statusManager) {
        this.statusManager = statusManager;
    }
}

