/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.util;

import ch.qos.logback.core.Context;
import ch.qos.logback.core.status.Status;
import ch.qos.logback.core.status.StatusManager;
import java.io.PrintStream;
import java.util.Iterator;

public class StatusPrinter {
    private static PrintStream ps = System.out;

    public static void setPrintStream(PrintStream printStream) {
        ps = printStream;
    }

    public static void print(Context context) {
        if (context == null) {
            throw new IllegalArgumentException("Context argument cannot be null");
        }
        StatusManager sm = context.getStatusManager();
        if (sm == null) {
            ps.println("WARN: Context named \"" + context.getName() + "\" has no status manager");
        }
        StatusPrinter.print(sm);
    }

    public static void print(StatusManager sm) {
        Iterator it = sm.iterator();
        while (it.hasNext()) {
            Status s = (Status)it.next();
            StatusPrinter.print("", s);
        }
    }

    private static void print(String indentation, Status s) {
        String prefix = s.hasChildren() ? indentation + "+ " : indentation + "|-";
        ps.println(prefix + s);
        if (s.getThrowable() != null) {
            s.getThrowable().printStackTrace(ps);
        }
        if (s.hasChildren()) {
            Iterator<Status> ite = s.iterator();
            while (ite.hasNext()) {
                Status child = ite.next();
                StatusPrinter.print(indentation + "  ", child);
            }
        }
    }
}

