/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.joran.action;

import ch.qos.logback.core.Context;
import ch.qos.logback.core.ContextBase;
import ch.qos.logback.core.joran.action.DummyAttributes;
import ch.qos.logback.core.joran.action.PropertyAction;
import ch.qos.logback.core.joran.action.SubstitutionPropertyAction;
import ch.qos.logback.core.joran.spi.InterpretationContext;
import ch.qos.logback.core.status.ErrorStatus;
import java.util.Iterator;
import junit.framework.TestCase;
import org.xml.sax.Attributes;

public class PropertyActionTest
extends TestCase {
    Context context;
    InterpretationContext ec;
    SubstitutionPropertyAction spAction;
    DummyAttributes atts = new DummyAttributes();

    protected void setUp() throws Exception {
        this.context = new ContextBase();
        this.ec = new InterpretationContext(this.context, null);
        this.spAction = new SubstitutionPropertyAction();
        this.spAction.setContext(this.context);
        super.setUp();
    }

    protected void tearDown() throws Exception {
        this.context = null;
        this.spAction = null;
        this.atts = null;
        super.tearDown();
    }

    public void testBegin() {
        this.atts.setValue("name", "v1");
        this.atts.setValue("value", "work");
        this.spAction.begin(this.ec, null, (Attributes)this.atts);
        PropertyActionTest.assertEquals((String)"work", (String)this.ec.getSubstitutionProperty("v1"));
    }

    public void testBeginNoValue() {
        this.atts.setValue("name", "v1");
        this.spAction.begin(this.ec, null, (Attributes)this.atts);
        PropertyActionTest.assertEquals((int)1, (int)this.context.getStatusManager().getCount());
        PropertyActionTest.assertTrue((boolean)this.checkError());
    }

    public void testBeginNoName() {
        this.atts.setValue("value", "v1");
        this.spAction.begin(this.ec, null, (Attributes)this.atts);
        PropertyActionTest.assertEquals((int)1, (int)this.context.getStatusManager().getCount());
        PropertyActionTest.assertTrue((boolean)this.checkError());
    }

    public void testBeginNothing() {
        this.spAction.begin(this.ec, null, (Attributes)this.atts);
        PropertyActionTest.assertEquals((int)1, (int)this.context.getStatusManager().getCount());
        PropertyActionTest.assertTrue((boolean)this.checkError());
    }

    public void testFileNotLoaded() {
        this.atts.setValue("file", "toto");
        this.atts.setValue("value", "work");
        this.spAction.begin(this.ec, null, (Attributes)this.atts);
        PropertyActionTest.assertEquals((int)1, (int)this.context.getStatusManager().getCount());
        PropertyActionTest.assertTrue((boolean)this.checkError());
    }

    public void testLoadFile() {
        this.atts.setValue("file", "src/test/input/joran/propertyActionTest.properties");
        this.spAction.begin(this.ec, null, (Attributes)this.atts);
        PropertyActionTest.assertEquals((String)"tata", (String)this.ec.getSubstitutionProperty("v1"));
        PropertyActionTest.assertEquals((String)"toto", (String)this.ec.getSubstitutionProperty("v2"));
    }

    public void testLoadNotPossible() {
        this.atts.setValue("file", "toto");
        this.spAction.begin(this.ec, null, (Attributes)this.atts);
        PropertyActionTest.assertEquals((int)2, (int)this.context.getStatusManager().getCount());
        PropertyActionTest.assertTrue((boolean)this.checkFileErrors());
    }

    private boolean checkError() {
        Iterator it = this.context.getStatusManager().getCopyOfStatusList().iterator();
        ErrorStatus es = (ErrorStatus)it.next();
        return PropertyAction.INVALID_ATTRIBUTES.equals(es.getMessage());
    }

    private boolean checkFileErrors() {
        Iterator it = this.context.getStatusManager().getCopyOfStatusList().iterator();
        ErrorStatus es1 = (ErrorStatus)it.next();
        boolean result1 = "Could not read properties file [toto].".equals(es1.getMessage());
        ErrorStatus es2 = (ErrorStatus)it.next();
        boolean result2 = "Ignoring configuration file [toto].".equals(es2.getMessage());
        return result1 && result2;
    }
}

