/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.pattern.parser;

import ch.qos.logback.core.pattern.parser.OptionTokenizer;
import ch.qos.logback.core.pattern.parser.ScanException;
import java.util.ArrayList;
import java.util.List;
import junit.framework.TestCase;

public class OptionTokenizerTest
extends TestCase {
    public void testEmpty() throws ScanException {
        List ol = new OptionTokenizer("").tokenize();
        ArrayList witness = new ArrayList();
        OptionTokenizerTest.assertEquals(witness, (Object)ol);
        ol = new OptionTokenizer(" ").tokenize();
        witness = new ArrayList();
        OptionTokenizerTest.assertEquals(witness, (Object)ol);
    }

    public void testSimple() throws ScanException {
        List ol = new OptionTokenizer("abc").tokenize();
        ArrayList<String> witness = new ArrayList<String>();
        witness.add("abc");
        OptionTokenizerTest.assertEquals(witness, (Object)ol);
    }

    public void testSingleQuote() throws ScanException {
        List ol = new OptionTokenizer("' '").tokenize();
        ArrayList<String> witness = new ArrayList<String>();
        witness.add(" ");
        OptionTokenizerTest.assertEquals(witness, (Object)ol);
        ol = new OptionTokenizer("' x\t'").tokenize();
        witness = new ArrayList();
        witness.add(" x\t");
        OptionTokenizerTest.assertEquals(witness, (Object)ol);
        ol = new OptionTokenizer("' x\\t'").tokenize();
        witness = new ArrayList();
        witness.add(" x\t");
        OptionTokenizerTest.assertEquals(witness, (Object)ol);
        ol = new OptionTokenizer("' x\\''").tokenize();
        witness = new ArrayList();
        witness.add(" x'");
        OptionTokenizerTest.assertEquals(witness, (Object)ol);
    }

    public void testDoubleQuote() throws ScanException {
        List ol = new OptionTokenizer("\" \"").tokenize();
        ArrayList<String> witness = new ArrayList<String>();
        witness.add(" ");
        OptionTokenizerTest.assertEquals(witness, (Object)ol);
        ol = new OptionTokenizer("\" x\t\"").tokenize();
        witness = new ArrayList();
        witness.add(" x\t");
        OptionTokenizerTest.assertEquals(witness, (Object)ol);
        ol = new OptionTokenizer("\" x\\t\"").tokenize();
        witness = new ArrayList();
        witness.add(" x\t");
        OptionTokenizerTest.assertEquals(witness, (Object)ol);
        ol = new OptionTokenizer("\" x\\\"\"").tokenize();
        witness = new ArrayList();
        witness.add(" x\"");
        OptionTokenizerTest.assertEquals(witness, (Object)ol);
    }

    public void testMultiple() throws ScanException {
        List ol = new OptionTokenizer("a, b").tokenize();
        ArrayList<String> witness = new ArrayList<String>();
        witness.add("a");
        witness.add("b");
        OptionTokenizerTest.assertEquals(witness, (Object)ol);
    }
}

