/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.util;

import ch.qos.logback.core.Context;
import ch.qos.logback.core.ContextBase;
import ch.qos.logback.core.util.OptionHelper;
import java.util.HashMap;
import java.util.Map;
import junit.framework.TestCase;

public class OptionHelperTest
extends TestCase {
    String text = "Testing ${v1} variable substitution ${v2}";
    String expected = "Testing if variable substitution works";
    Context context = new ContextBase();
    Map<String, String> secondaryMap;

    protected void setUp() throws Exception {
        this.secondaryMap = new HashMap<String, String>();
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testLiteral() {
        String noSubst = "hello world";
        String result = OptionHelper.substVars((String)noSubst, (Context)this.context);
        OptionHelperTest.assertEquals((String)noSubst, (String)result);
    }

    public void testUndefinedValues() {
        String withUndefinedValues = "${axyz}";
        String result = OptionHelper.substVars((String)withUndefinedValues, (Context)this.context);
        OptionHelperTest.assertEquals((String)"axyz_IS_UNDEFINED", (String)result);
    }

    public void testSubstVarsVariableNotClosed() {
        String noSubst = "testing if ${v1 works";
        try {
            String result = OptionHelper.substVars((String)noSubst, (Context)this.context);
            OptionHelperTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testSubstVarsContextOnly() {
        this.context.putProperty("v1", "if");
        this.context.putProperty("v2", "works");
        String result = OptionHelper.substVars((String)this.text, (Context)this.context);
        OptionHelperTest.assertEquals((String)this.expected, (String)result);
    }

    public void testSubstVarsSystemProperties() {
        System.setProperty("v1", "if");
        System.setProperty("v2", "works");
        String result = OptionHelper.substVars((String)this.text, (Context)this.context);
        OptionHelperTest.assertEquals((String)this.expected, (String)result);
        System.clearProperty("v1");
        System.clearProperty("v2");
    }

    public void testSubstVarsWithDefault() {
        this.context.putProperty("v1", "if");
        String textWithDefault = "Testing ${v1} variable substitution ${v2:-toto}";
        String resultWithDefault = "Testing if variable substitution toto";
        String result = OptionHelper.substVars((String)textWithDefault, (Context)this.context);
        OptionHelperTest.assertEquals((String)resultWithDefault, (String)result);
    }

    public void testSubstVarsRecursive() {
        this.context.putProperty("v1", "if");
        this.context.putProperty("v2", "${v3}");
        this.context.putProperty("v3", "works");
        String result = OptionHelper.substVars((String)this.text, (Context)this.context);
        OptionHelperTest.assertEquals((String)this.expected, (String)result);
    }
}

