/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.spi;

import ch.qos.logback.core.Appender;
import ch.qos.logback.core.spi.AppenderAttachable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AppenderAttachableImpl<E>
implements AppenderAttachable<E> {
    private final List<Appender<E>> appenderList = new ArrayList<Appender<E>>();
    private final ReadWriteLock rwLock = new ReentrantReadWriteLock();
    private final Lock r = this.rwLock.readLock();
    private final Lock w = this.rwLock.writeLock();

    @Override
    public void addAppender(Appender<E> newAppender) {
        if (newAppender == null) {
            throw new IllegalArgumentException("Null argument disallowed");
        }
        this.w.lock();
        if (!this.appenderList.contains(newAppender)) {
            this.appenderList.add(newAppender);
        }
        this.w.unlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int appendLoopOnAppenders(E e) {
        int size = 0;
        this.r.lock();
        try {
            for (Appender<E> appender : this.appenderList) {
                appender.doAppend(e);
                ++size;
            }
        }
        finally {
            this.r.unlock();
        }
        return size;
    }

    @Override
    public Iterator<Appender<E>> iteratorForAppenders() {
        this.r.lock();
        ArrayList<Appender<E>> copy = new ArrayList<Appender<E>>(this.appenderList);
        this.r.unlock();
        return copy.iterator();
    }

    @Override
    public Appender<E> getAppender(String name) {
        if (name == null) {
            return null;
        }
        this.r.lock();
        for (Appender<E> appender : this.appenderList) {
            if (!name.equals(appender.getName())) continue;
            this.r.unlock();
            return appender;
        }
        this.r.unlock();
        return null;
    }

    @Override
    public boolean isAttached(Appender appender) {
        if (appender == null) {
            return false;
        }
        this.r.lock();
        for (Appender<E> a : this.appenderList) {
            if (a != appender) continue;
            this.r.unlock();
            return true;
        }
        this.r.unlock();
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void detachAndStopAllAppenders() {
        try {
            this.w.lock();
            for (Appender<E> a : this.appenderList) {
                a.stop();
            }
            this.appenderList.clear();
        }
        finally {
            this.w.unlock();
        }
    }

    @Override
    public boolean detachAppender(Appender appender) {
        if (appender == null) {
            return false;
        }
        this.w.lock();
        boolean result = this.appenderList.remove(appender);
        this.w.unlock();
        return result;
    }

    @Override
    public boolean detachAppender(String name) {
        if (name == null) {
            return false;
        }
        this.w.lock();
        for (Appender<E> a : this.appenderList) {
            if (!name.equals(a.getName())) continue;
            this.w.unlock();
            return this.appenderList.remove(a);
        }
        this.w.unlock();
        return false;
    }
}

