/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.appender;

import ch.qos.logback.core.AppenderBase;
import ch.qos.logback.core.ConsoleAppender;
import ch.qos.logback.core.Layout;
import ch.qos.logback.core.appender.AbstractAppenderTest;
import ch.qos.logback.core.layout.DummyLayout;
import ch.qos.logback.core.layout.NopLayout;
import ch.qos.logback.core.util.TeeOutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import junit.framework.Test;
import junit.framework.TestSuite;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConsoleAppenderTest
extends AbstractAppenderTest<Object> {
    TeeOutputStream tee;
    PrintStream original;

    public ConsoleAppenderTest(String arg) {
        super(arg);
    }

    protected void setUp() throws Exception {
        this.original = System.out;
        this.tee = new TeeOutputStream(null);
        System.setOut(new PrintStream(this.tee));
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        System.setOut(this.original);
    }

    @Override
    protected AppenderBase<Object> getAppender() {
        return new ConsoleAppender();
    }

    @Override
    protected AppenderBase<Object> getConfiguredAppender() {
        ConsoleAppender ca = new ConsoleAppender();
        ca.setLayout(new NopLayout());
        ca.start();
        return ca;
    }

    public void testBasic() {
        ConsoleAppender ca = (ConsoleAppender)this.getAppender();
        ca.setLayout(new DummyLayout());
        ca.start();
        ca.doAppend(new Object());
        ConsoleAppenderTest.assertEquals((String)DummyLayout.DUMMY, (String)this.tee.toString());
    }

    public void testOpen() {
        ConsoleAppender ca = (ConsoleAppender)this.getAppender();
        DummyLayout dummyLayout = new DummyLayout();
        dummyLayout.setFileHeader("open");
        ca.setLayout(dummyLayout);
        ca.start();
        ca.doAppend(new Object());
        ca.stop();
        ConsoleAppenderTest.assertEquals((String)("open" + Layout.LINE_SEP + DummyLayout.DUMMY), (String)this.tee.toString());
    }

    public void testClose() {
        ConsoleAppender ca = (ConsoleAppender)this.getAppender();
        DummyLayout dummyLayout = new DummyLayout();
        dummyLayout.setFileFooter("CLOSED");
        ca.setLayout(dummyLayout);
        ca.start();
        ca.doAppend(new Object());
        ca.stop();
        ConsoleAppenderTest.assertEquals((String)(DummyLayout.DUMMY + "CLOSED"), (String)this.tee.toString());
    }

    public void testUTF16BE() throws UnsupportedEncodingException {
        ConsoleAppender ca = (ConsoleAppender)this.getAppender();
        ca.setLayout(new DummyLayout());
        String encodingName = "UTF-16BE";
        ca.setEncoding(encodingName);
        ca.start();
        ca.doAppend(new Object());
        ConsoleAppenderTest.assertEquals((String)DummyLayout.DUMMY, (String)new String(this.tee.toByteArray(), encodingName));
    }

    public static Test xxsuite() {
        TestSuite suite = new TestSuite();
        suite.addTestSuite(ConsoleAppenderTest.class);
        return suite;
    }
}

