/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.appender;

import ch.qos.logback.core.AppenderBase;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.ContextBase;
import ch.qos.logback.core.FileAppender;
import ch.qos.logback.core.appender.AbstractAppenderTest;
import ch.qos.logback.core.layout.DummyLayout;
import ch.qos.logback.core.layout.NopLayout;
import ch.qos.logback.core.util.FileUtil;
import java.io.File;
import java.util.Random;

public class FileAppenderTest
extends AbstractAppenderTest {
    public FileAppenderTest(String arg0) {
        super(arg0);
    }

    protected void setUp() throws Exception {
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    protected AppenderBase getAppender() {
        return new FileAppender();
    }

    protected AppenderBase getConfiguredAppender() {
        FileAppender appender = new FileAppender();
        appender.setLayout(new NopLayout());
        appender.setFile("temp.log");
        appender.setName("temp.log");
        appender.setContext((Context)new ContextBase());
        appender.start();
        return appender;
    }

    public void test() {
        String filename = "target/test-output/temp.log";
        FileAppender appender = new FileAppender();
        appender.setLayout(new DummyLayout());
        appender.setAppend(false);
        appender.setFile(filename);
        appender.setName("temp.log");
        appender.setContext((Context)new ContextBase());
        appender.start();
        appender.doAppend(new Object());
        appender.stop();
        File file = new File(filename);
        FileAppenderTest.assertTrue((boolean)file.exists());
        FileAppenderTest.assertTrue((String)("failed to delete " + file.getAbsolutePath()), (boolean)file.delete());
    }

    public void testCreateParentFolders() {
        int diff = new Random().nextInt(100);
        String filename = "target/test-output//fat" + diff + "/testing.txt";
        File file = new File(filename);
        FileAppender appender = new FileAppender();
        appender.setLayout(new DummyLayout());
        appender.setAppend(false);
        appender.setFile(filename);
        appender.setName("testCreateParentFolders");
        appender.setContext((Context)new ContextBase());
        appender.start();
        appender.doAppend(new Object());
        appender.stop();
        FileAppenderTest.assertFalse((boolean)FileUtil.mustCreateParentDirectories((File)file));
        FileAppenderTest.assertTrue((boolean)file.exists());
        FileAppenderTest.assertTrue((String)("failed to delete " + file.getAbsolutePath()), (boolean)file.delete());
        File parent = file.getParentFile();
        FileAppenderTest.assertTrue((String)("failed to delete " + parent.getAbsolutePath()), (boolean)parent.delete());
    }
}

