/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.joran;

import ch.qos.logback.core.Context;
import ch.qos.logback.core.ContextBase;
import ch.qos.logback.core.joran.TrivialConfigurator;
import ch.qos.logback.core.joran.action.Action;
import ch.qos.logback.core.joran.action.ext.IncAction;
import ch.qos.logback.core.joran.spi.Pattern;
import ch.qos.logback.core.status.Status;
import ch.qos.logback.core.status.StatusListener;
import ch.qos.logback.core.status.TrivialStatusListener;
import java.util.HashMap;
import org.junit.Assert;
import org.junit.Test;

public class TrivialcConfiguratorTest {
    Context context = new ContextBase();

    public void doTest(String filename) throws Exception {
        HashMap<Pattern, Action> rulesMap = new HashMap<Pattern, Action>();
        rulesMap.put(new Pattern("x/inc"), new IncAction());
        TrivialConfigurator gc = new TrivialConfigurator(rulesMap);
        gc.setContext(this.context);
        gc.doConfigure("src/test/input/joran/" + filename);
    }

    @Test
    public void smokeTezt() throws Exception {
        int oldBeginCount = IncAction.beginCount;
        int oldEndCount = IncAction.endCount;
        int oldErrorCount = IncAction.errorCount;
        this.doTest("inc.xml");
        Assert.assertEquals((long)oldErrorCount, (long)IncAction.errorCount);
        Assert.assertEquals((long)(oldBeginCount + 1), (long)IncAction.beginCount);
        Assert.assertEquals((long)(oldEndCount + 1), (long)IncAction.endCount);
    }

    @Test
    public void teztInexistentFile() {
        TrivialStatusListener tsl = new TrivialStatusListener();
        String filename = "nothereBLAH.xml";
        this.context.getStatusManager().add((StatusListener)tsl);
        try {
            this.doTest(filename);
        }
        catch (Exception e) {
            // empty catch block
        }
        Assert.assertTrue((String)(tsl.list.size() + " should be greater than or equal to 1"), (tsl.list.size() >= 1 ? 1 : 0) != 0);
        Status s0 = tsl.list.get(0);
        Assert.assertTrue((boolean)s0.getMessage().startsWith("Could not open [" + filename + "]"));
    }

    @Test
    public void teztIllFormedXML() {
        TrivialStatusListener tsl = new TrivialStatusListener();
        String filename = "illformed.xml";
        this.context.getStatusManager().add((StatusListener)tsl);
        try {
            this.doTest(filename);
        }
        catch (Exception e) {
            // empty catch block
        }
        Assert.assertEquals((long)2L, (long)tsl.list.size());
        Status s0 = tsl.list.get(0);
        Assert.assertTrue((boolean)s0.getMessage().startsWith("Parsing fatal error on line 5 and column 3"));
        Status s1 = tsl.list.get(1);
        Assert.assertTrue((boolean)s1.getMessage().startsWith("Problem parsing XML document. See previously reported errors. Abandoning all further processing."));
    }
}

