/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.joran.spi;

import ch.qos.logback.core.Context;
import ch.qos.logback.core.ContextBase;
import ch.qos.logback.core.joran.action.IADataForComplexProperty;
import ch.qos.logback.core.joran.spi.Door;
import ch.qos.logback.core.joran.spi.House;
import ch.qos.logback.core.joran.spi.HouseColor;
import ch.qos.logback.core.joran.spi.PropertySetter;
import ch.qos.logback.core.joran.spi.SwimmingPool;
import ch.qos.logback.core.joran.spi.Window;
import ch.qos.logback.core.spi.FilterReply;
import ch.qos.logback.core.util.AggregationType;
import ch.qos.logback.core.util.StatusPrinter;
import junit.framework.TestCase;

public class PropertySetterTest
extends TestCase {
    public void testCanAggregateComponent() {
        House house = new House();
        PropertySetter setter = new PropertySetter((Object)house);
        PropertySetterTest.assertEquals((Object)AggregationType.AS_COMPLEX_PROPERTY, (Object)setter.computeAggregationType("door"));
        PropertySetterTest.assertEquals((Object)AggregationType.AS_BASIC_PROPERTY, (Object)setter.computeAggregationType("count"));
        PropertySetterTest.assertEquals((Object)AggregationType.AS_BASIC_PROPERTY, (Object)setter.computeAggregationType("Count"));
        PropertySetterTest.assertEquals((Object)AggregationType.AS_BASIC_PROPERTY, (Object)setter.computeAggregationType("name"));
        PropertySetterTest.assertEquals((Object)AggregationType.AS_BASIC_PROPERTY, (Object)setter.computeAggregationType("Name"));
        PropertySetterTest.assertEquals((Object)AggregationType.AS_BASIC_PROPERTY, (Object)setter.computeAggregationType("Duration"));
        PropertySetterTest.assertEquals((Object)AggregationType.AS_BASIC_PROPERTY, (Object)setter.computeAggregationType("fs"));
        PropertySetterTest.assertEquals((Object)AggregationType.AS_BASIC_PROPERTY, (Object)setter.computeAggregationType("open"));
        PropertySetterTest.assertEquals((Object)AggregationType.AS_BASIC_PROPERTY, (Object)setter.computeAggregationType("Open"));
        PropertySetterTest.assertEquals((Object)AggregationType.AS_COMPLEX_PROPERTY_COLLECTION, (Object)setter.computeAggregationType("Window"));
        PropertySetterTest.assertEquals((Object)AggregationType.AS_BASIC_PROPERTY_COLLECTION, (Object)setter.computeAggregationType("adjective"));
        PropertySetterTest.assertEquals((Object)AggregationType.AS_BASIC_PROPERTY, (Object)setter.computeAggregationType("filterReply"));
        PropertySetterTest.assertEquals((Object)AggregationType.AS_BASIC_PROPERTY, (Object)setter.computeAggregationType("houseColor"));
        System.out.println();
    }

    public void testSetProperty() {
        House house = new House();
        PropertySetter setter = new PropertySetter((Object)house);
        setter.setProperty("count", "10");
        setter.setProperty("name", "jack");
        setter.setProperty("open", "true");
        PropertySetterTest.assertEquals((int)10, (int)house.getCount());
        PropertySetterTest.assertEquals((String)"jack", (String)house.getName());
        PropertySetterTest.assertTrue((boolean)house.isOpen());
        house = new House();
        setter = new PropertySetter((Object)house);
        setter.setProperty("Count", "10");
        setter.setProperty("Name", "jack");
        setter.setProperty("Open", "true");
        PropertySetterTest.assertEquals((int)10, (int)house.getCount());
        PropertySetterTest.assertEquals((String)"jack", (String)house.getName());
        PropertySetterTest.assertTrue((boolean)house.isOpen());
    }

    public void testSetCamelProperty() {
        House house = new House();
        PropertySetter setter = new PropertySetter((Object)house);
        setter.setProperty("camelCase", "trot");
        PropertySetterTest.assertEquals((String)"trot", (String)house.getCamelCase());
        setter.setProperty("camelCase", "gh");
        PropertySetterTest.assertEquals((String)"gh", (String)house.getCamelCase());
    }

    public void testSetComplexProperty() {
        House house = new House();
        Door door = new Door();
        PropertySetter setter = new PropertySetter((Object)house);
        setter.setComplexProperty("door", (Object)door);
        PropertySetterTest.assertEquals((Object)door, (Object)house.getDoor());
    }

    public void testSetComplexProperty2() {
        House house = new House();
        PropertySetter setter = new PropertySetter((Object)house);
        IADataForComplexProperty actionData = new IADataForComplexProperty(setter, AggregationType.AS_COMPLEX_PROPERTY, "door");
        Class clazz = setter.findUnequivocallyInstantiableClass(actionData);
        PropertySetterTest.assertNotNull((Object)clazz);
        PropertySetterTest.assertEquals((String)Door.class.getName(), (String)clazz.getName());
    }

    public void testPropertyCollection() {
        House house = new House();
        ContextBase context = new ContextBase();
        PropertySetter setter = new PropertySetter((Object)house);
        setter.setContext((Context)context);
        setter.addBasicProperty("adjective", "nice");
        setter.addBasicProperty("adjective", "big");
        StatusPrinter.print((Context)context);
        PropertySetterTest.assertEquals((int)2, (int)house.adjectiveList.size());
        PropertySetterTest.assertEquals((String)"nice", (String)house.adjectiveList.get(0));
        PropertySetterTest.assertEquals((String)"big", (String)house.adjectiveList.get(1));
    }

    public void testComplexCollection() {
        House house = new House();
        PropertySetter setter = new PropertySetter((Object)house);
        Window w1 = new Window();
        w1.handle = 10;
        Window w2 = new Window();
        w2.handle = 20;
        setter.addComplexProperty("window", (Object)w1);
        setter.addComplexProperty("window", (Object)w2);
        PropertySetterTest.assertEquals((int)2, (int)house.windowList.size());
        PropertySetterTest.assertEquals((int)10, (int)house.windowList.get((int)0).handle);
        PropertySetterTest.assertEquals((int)20, (int)house.windowList.get((int)1).handle);
    }

    public void testSetComplexWithCamelCaseName() {
        House house = new House();
        SwimmingPool pool = new SwimmingPool();
        PropertySetter setter = new PropertySetter((Object)house);
        setter.setComplexProperty("swimmingPool", (Object)pool);
        PropertySetterTest.assertEquals((Object)pool, (Object)house.getSwimmingPool());
    }

    public void testDuration() {
        House house = new House();
        PropertySetter setter = new PropertySetter((Object)house);
        setter.setProperty("duration", "1.4 seconds");
        PropertySetterTest.assertEquals((long)1400L, (long)house.getDuration().getMilliseconds());
    }

    public void testFileSize() {
        House house = new House();
        PropertySetter setter = new PropertySetter((Object)house);
        setter.setProperty("fs", "2 kb");
        PropertySetterTest.assertEquals((long)2048L, (long)house.getFs().getSize());
    }

    public void testFilterReply() {
        House house = new House();
        PropertySetter setter = new PropertySetter((Object)house);
        setter.setProperty("filterReply", "ACCEPT");
        PropertySetterTest.assertEquals((Object)FilterReply.ACCEPT, (Object)house.getFilterReply());
    }

    public void testEnum() {
        House house = new House();
        PropertySetter setter = new PropertySetter((Object)house);
        setter.setProperty("houseColor", "BLUE");
        PropertySetterTest.assertEquals((Object)((Object)HouseColor.BLUE), (Object)((Object)house.getHouseColor()));
    }
}

