/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.util;

import ch.qos.logback.core.util.Duration;
import junit.framework.TestCase;

public class DurationTest
extends TestCase {
    static long HOURS_CO = 3600L;
    static long DAYS_CO = 86400L;

    public DurationTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void test() {
        Duration d = Duration.valueOf((String)"12");
        DurationTest.assertEquals((long)12L, (long)d.getMilliseconds());
        d = Duration.valueOf((String)"8 milliseconds");
        DurationTest.assertEquals((long)8L, (long)d.getMilliseconds());
        d = Duration.valueOf((String)"10.7 millisecond");
        DurationTest.assertEquals((long)10L, (long)d.getMilliseconds());
        d = Duration.valueOf((String)"10 SECOnds");
        DurationTest.assertEquals((long)10000L, (long)d.getMilliseconds());
        d = Duration.valueOf((String)"12seconde");
        DurationTest.assertEquals((long)12000L, (long)d.getMilliseconds());
        d = Duration.valueOf((String)"14 SECONDES");
        DurationTest.assertEquals((long)14000L, (long)d.getMilliseconds());
        d = Duration.valueOf((String)"12second");
        DurationTest.assertEquals((long)12000L, (long)d.getMilliseconds());
        d = Duration.valueOf((String)"10.7 seconds");
        DurationTest.assertEquals((long)10700L, (long)d.getMilliseconds());
        d = Duration.valueOf((String)"1 minute");
        DurationTest.assertEquals((long)60000L, (long)d.getMilliseconds());
        d = Duration.valueOf((String)"2.2 minutes");
        DurationTest.assertEquals((long)132000L, (long)d.getMilliseconds());
        d = Duration.valueOf((String)"1 hour");
        DurationTest.assertEquals((long)(1000L * HOURS_CO), (long)d.getMilliseconds());
        d = Duration.valueOf((String)"4.2 hours");
        DurationTest.assertEquals((long)(4200L * HOURS_CO), (long)d.getMilliseconds());
        d = Duration.valueOf((String)"5 days");
        DurationTest.assertEquals((long)(5000L * DAYS_CO), (long)d.getMilliseconds());
    }
}

