/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.util;

import ch.qos.logback.core.util.Duration;
import org.junit.Assert;
import org.junit.Test;

public class DurationTest {
    static long HOURS_CO = 3600L;
    static long DAYS_CO = 86400L;

    @Test
    public void test() {
        Duration d = Duration.valueOf((String)"12");
        Assert.assertEquals((long)12L, (long)d.getMilliseconds());
        d = Duration.valueOf((String)"8 milliseconds");
        Assert.assertEquals((long)8L, (long)d.getMilliseconds());
        d = Duration.valueOf((String)"10.7 millisecond");
        Assert.assertEquals((long)10L, (long)d.getMilliseconds());
        d = Duration.valueOf((String)"10 SECOnds");
        Assert.assertEquals((long)10000L, (long)d.getMilliseconds());
        d = Duration.valueOf((String)"12seconde");
        Assert.assertEquals((long)12000L, (long)d.getMilliseconds());
        d = Duration.valueOf((String)"14 SECONDES");
        Assert.assertEquals((long)14000L, (long)d.getMilliseconds());
        d = Duration.valueOf((String)"12second");
        Assert.assertEquals((long)12000L, (long)d.getMilliseconds());
        d = Duration.valueOf((String)"10.7 seconds");
        Assert.assertEquals((long)10700L, (long)d.getMilliseconds());
        d = Duration.valueOf((String)"1 minute");
        Assert.assertEquals((long)60000L, (long)d.getMilliseconds());
        d = Duration.valueOf((String)"2.2 minutes");
        Assert.assertEquals((long)132000L, (long)d.getMilliseconds());
        d = Duration.valueOf((String)"1 hour");
        Assert.assertEquals((long)(1000L * HOURS_CO), (long)d.getMilliseconds());
        d = Duration.valueOf((String)"4.2 hours");
        Assert.assertEquals((long)(4200L * HOURS_CO), (long)d.getMilliseconds());
        d = Duration.valueOf((String)"5 days");
        Assert.assertEquals((long)(5000L * DAYS_CO), (long)d.getMilliseconds());
    }
}

