/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.rolling;

import ch.qos.logback.core.AppenderBase;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.ContextBase;
import ch.qos.logback.core.appender.AbstractAppenderTest;
import ch.qos.logback.core.layout.DummyLayout;
import ch.qos.logback.core.rolling.RollingFileAppender;
import ch.qos.logback.core.rolling.TimeBasedRollingPolicy;
import ch.qos.logback.core.status.StatusManager;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RollingFileAppenderTest
extends AbstractAppenderTest<Object> {
    RollingFileAppender<Object> rfa = new RollingFileAppender();
    Context context = new ContextBase();
    TimeBasedRollingPolicy<Object> tbrp = new TimeBasedRollingPolicy();

    @Before
    public void setUp() throws Exception {
        this.rfa.setLayout(new DummyLayout());
        this.rfa.setName("test");
        this.rfa.setRollingPolicy(this.tbrp);
        this.tbrp.setContext(this.context);
        this.tbrp.setParent(this.rfa);
    }

    @After
    public void tearDown() throws Exception {
    }

    @Override
    protected AppenderBase<Object> getAppender() {
        return this.rfa;
    }

    @Override
    protected AppenderBase<Object> getConfiguredAppender() {
        this.rfa.setContext(this.context);
        this.tbrp.setFileNamePattern("toto-%d.log");
        this.tbrp.start();
        this.rfa.start();
        return this.rfa;
    }

    @Test
    public void testPrudentModeLogicalImplications() {
        this.tbrp.setFileNamePattern("toto-%d.log");
        this.tbrp.start();
        this.rfa.setContext(this.context);
        this.rfa.setFile("some non null value");
        this.rfa.setAppend(false);
        this.rfa.setImmediateFlush(false);
        this.rfa.setBufferedIO(true);
        this.rfa.setPrudent(true);
        this.rfa.start();
        Assert.assertTrue((boolean)this.rfa.getImmediateFlush());
        Assert.assertTrue((boolean)this.rfa.isAppend());
        Assert.assertFalse((boolean)this.rfa.isBufferedIO());
        Assert.assertNull((Object)this.rfa.rawFileProperty());
        Assert.assertTrue((boolean)this.rfa.isStarted());
    }

    @Test
    public void testPrudentModeLogicalImplicationsOnCompression() {
        this.tbrp.setFileNamePattern("toto-%d.log.zip");
        this.tbrp.start();
        this.rfa.setContext(this.context);
        this.rfa.setAppend(false);
        this.rfa.setImmediateFlush(false);
        this.rfa.setBufferedIO(true);
        this.rfa.setPrudent(true);
        this.rfa.start();
        StatusManager sm = this.context.getStatusManager();
        Assert.assertFalse((boolean)this.rfa.isStarted());
        Assert.assertEquals((long)2L, (long)sm.getLevel());
    }
}

