/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.rolling;

import ch.qos.logback.core.Context;
import ch.qos.logback.core.ContextBase;
import ch.qos.logback.core.FileAppender;
import ch.qos.logback.core.layout.DummyLayout;
import ch.qos.logback.core.rolling.FixedWindowRollingPolicy;
import ch.qos.logback.core.rolling.RollingFileAppender;
import ch.qos.logback.core.rolling.RollingPolicy;
import ch.qos.logback.core.rolling.SizeBasedTriggeringPolicy;
import ch.qos.logback.core.rolling.TriggeringPolicy;
import ch.qos.logback.core.testUtil.Env;
import ch.qos.logback.core.util.Compare;
import java.io.File;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class SizeBasedRollingTest {
    @Before
    public void setUp() {
        File target = new File("target/test-output/sizeBased-test2.log");
        target.mkdirs();
        target.delete();
        target = new File("target/test-output/sbr-test3.log");
        target.mkdirs();
        target.delete();
    }

    @After
    public void tearDown() {
    }

    @Test
    public void test1() throws Exception {
        ContextBase context = new ContextBase();
        DummyLayout layout = new DummyLayout();
        RollingFileAppender rfa = new RollingFileAppender();
        rfa.setLayout(layout);
        rfa.setContext((Context)new ContextBase());
        FixedWindowRollingPolicy fwrp = new FixedWindowRollingPolicy();
        fwrp.setContext((Context)context);
        fwrp.setParent((FileAppender)rfa);
        SizeBasedTriggeringPolicy sbtp = new SizeBasedTriggeringPolicy();
        sbtp.setContext((Context)context);
        sbtp.setMaxFileSize("100");
        sbtp.start();
        fwrp.setFileNamePattern("target/test-output/sizeBased-test1.%i");
        try {
            fwrp.start();
            Assert.fail((String)"The absence of activeFileName option should have caused an exception.");
        }
        catch (IllegalStateException e) {
            return;
        }
    }

    @Test
    public void test2() throws Exception {
        ContextBase context = new ContextBase();
        DummyLayout layout = new DummyLayout("0123456789");
        RollingFileAppender rfa = new RollingFileAppender();
        rfa.setName("ROLLING");
        rfa.setLayout(layout);
        rfa.setContext((Context)context);
        rfa.setFile("target/test-output/sizeBased-test2.log");
        FixedWindowRollingPolicy swrp = new FixedWindowRollingPolicy();
        swrp.setContext((Context)context);
        SizeBasedTriggeringPolicy sbtp = new SizeBasedTriggeringPolicy();
        sbtp.setContext((Context)context);
        sbtp.setMaxFileSize("100");
        swrp.setMinIndex(0);
        swrp.setFileNamePattern("target/test-output/sizeBased-test2.%i");
        swrp.setParent((FileAppender)rfa);
        swrp.start();
        rfa.setRollingPolicy((RollingPolicy)swrp);
        rfa.setTriggeringPolicy((TriggeringPolicy)sbtp);
        rfa.start();
        for (int i = 0; i < 45; ++i) {
            Thread.sleep(10L);
            rfa.doAppend((Object)"hello");
        }
        Assert.assertTrue((boolean)new File("target/test-output/sizeBased-test2.log").exists());
        Assert.assertTrue((boolean)new File("target/test-output/sizeBased-test2.0").exists());
        Assert.assertTrue((boolean)new File("target/test-output/sizeBased-test2.1").exists());
        if (!Env.isWindows()) {
            Assert.assertTrue((boolean)Compare.compare("target/test-output/sizeBased-test2.log", "src/test/witness/rolling/sbr-test2.l"));
            Assert.assertTrue((boolean)Compare.compare("target/test-output/sizeBased-test2.0", "src/test/witness/rolling/sbr-test2.0"));
            Assert.assertTrue((boolean)Compare.compare("target/test-output/sizeBased-test2.1", "src/test/witness/rolling/sbr-test2.1"));
        }
    }

    @Test
    public void test3() throws Exception {
        ContextBase context = new ContextBase();
        DummyLayout layout = new DummyLayout("0123456789");
        RollingFileAppender rfa = new RollingFileAppender();
        rfa.setLayout(layout);
        rfa.setContext((Context)context);
        rfa.setFile("target/test-output/sbr-test3.log");
        FixedWindowRollingPolicy fwrp = new FixedWindowRollingPolicy();
        fwrp.setContext((Context)context);
        SizeBasedTriggeringPolicy sbtp = new SizeBasedTriggeringPolicy();
        sbtp.setContext((Context)context);
        sbtp.setMaxFileSize("100");
        fwrp.setMinIndex(0);
        fwrp.setFileNamePattern("target/test-output/sbr-test3.%i.gz");
        fwrp.setParent((FileAppender)rfa);
        fwrp.start();
        rfa.setRollingPolicy((RollingPolicy)fwrp);
        rfa.setTriggeringPolicy((TriggeringPolicy)sbtp);
        rfa.start();
        for (int i = 0; i < 25; ++i) {
            Thread.sleep(10L);
            rfa.doAppend((Object)"hello");
        }
        Assert.assertTrue((boolean)new File("target/test-output/sbr-test3.log").exists());
        Assert.assertTrue((boolean)new File("target/test-output/sbr-test3.0.gz").exists());
        Assert.assertTrue((boolean)new File("target/test-output/sbr-test3.1.gz").exists());
        if (!Env.isWindows()) {
            Assert.assertTrue((boolean)Compare.compare("target/test-output/sbr-test3.log", "src/test/witness/rolling/sbr-test3.l"));
            Assert.assertTrue((boolean)Compare.gzCompare("target/test-output/sbr-test3.0.gz", "src/test/witness/rolling/sbr-test3.0.gz"));
            Assert.assertTrue((boolean)Compare.gzCompare("target/test-output/sbr-test3.1.gz", "src/test/witness/rolling/sbr-test3.1.gz"));
        }
    }
}

