/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.appender;

import ch.qos.logback.core.AppenderBase;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.ContextBase;
import ch.qos.logback.core.FileAppender;
import ch.qos.logback.core.appender.AbstractAppenderTest;
import ch.qos.logback.core.layout.DummyLayout;
import ch.qos.logback.core.layout.NopLayout;
import ch.qos.logback.core.status.Status;
import ch.qos.logback.core.status.StatusManager;
import ch.qos.logback.core.util.FileUtil;
import ch.qos.logback.core.util.StatusPrinter;
import java.io.File;
import java.util.List;
import java.util.Random;
import org.junit.Assert;
import org.junit.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileAppenderTest
extends AbstractAppenderTest<Object> {
    int diff = new Random().nextInt(100);
    Context context = new ContextBase();

    @Override
    protected AppenderBase<Object> getAppender() {
        return new FileAppender();
    }

    @Override
    protected AppenderBase<Object> getConfiguredAppender() {
        FileAppender appender = new FileAppender();
        appender.setLayout(new NopLayout());
        appender.setFile("temp.log");
        appender.setName("temp.log");
        appender.setContext(this.context);
        appender.start();
        return appender;
    }

    @Test
    public void smoke() {
        String filename = "target/test-output/temp.log";
        FileAppender appender = new FileAppender();
        appender.setLayout(new DummyLayout());
        appender.setAppend(false);
        appender.setFile(filename);
        appender.setName("temp.log");
        appender.setContext(this.context);
        appender.start();
        appender.doAppend(new Object());
        appender.stop();
        File file = new File(filename);
        Assert.assertTrue((boolean)file.exists());
        Assert.assertTrue((String)("failed to delete " + file.getAbsolutePath()), (boolean)file.delete());
    }

    @Test
    public void testCreateParentFolders() {
        String filename = "target/test-output//fat" + this.diff + "/testing.txt";
        File file = new File(filename);
        FileAppender appender = new FileAppender();
        appender.setLayout(new DummyLayout());
        appender.setAppend(false);
        appender.setFile(filename);
        appender.setName("testCreateParentFolders");
        appender.setContext(this.context);
        appender.start();
        appender.doAppend(new Object());
        appender.stop();
        Assert.assertFalse((boolean)FileUtil.mustCreateParentDirectories((File)file));
        Assert.assertTrue((boolean)file.exists());
        Assert.assertTrue((String)("failed to delete " + file.getAbsolutePath()), (boolean)file.delete());
        File parent = file.getParentFile();
        Assert.assertTrue((String)("failed to delete " + parent.getAbsolutePath()), (boolean)parent.delete());
    }

    @Test
    public void testPrudentModeLogicalImplications() {
        String filename = "target/test-output/" + this.diff + "testing.txt";
        File file = new File(filename);
        FileAppender appender = new FileAppender();
        appender.setLayout(new DummyLayout());
        appender.setFile(filename);
        appender.setName("testPrudentMode");
        appender.setContext(this.context);
        appender.setAppend(false);
        appender.setImmediateFlush(false);
        appender.setBufferedIO(true);
        appender.setPrudent(true);
        appender.start();
        Assert.assertTrue((boolean)appender.getImmediateFlush());
        Assert.assertTrue((boolean)appender.isAppend());
        Assert.assertFalse((boolean)appender.isBufferedIO());
        StatusManager sm = this.context.getStatusManager();
        Assert.assertEquals((long)1L, (long)sm.getLevel());
        List statusList = sm.getCopyOfStatusList();
        Assert.assertTrue((String)("Expecting status list size to be larger than 3, but was " + statusList.size()), (statusList.size() > 3 ? 1 : 0) != 0);
        String msg1 = ((Status)statusList.get(1)).getMessage();
        Assert.assertTrue((String)("Got message [" + msg1 + "]"), (boolean)msg1.startsWith("Setting \"Append\" property"));
        StatusPrinter.print((Context)this.context);
        appender.doAppend(new Object());
        appender.stop();
        Assert.assertTrue((boolean)file.exists());
        Assert.assertTrue((String)("failed to delete " + file.getAbsolutePath()), (boolean)file.delete());
    }
}

