/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.joran.spi;

import ch.qos.logback.core.Context;
import ch.qos.logback.core.ContextBase;
import ch.qos.logback.core.joran.action.Action;
import ch.qos.logback.core.joran.spi.InterpretationContext;
import ch.qos.logback.core.joran.spi.Pattern;
import ch.qos.logback.core.joran.spi.SimpleRuleStore;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.xml.sax.Attributes;

public class SimpleStoreTest {
    @Test
    public void test1() throws Exception {
        SimpleRuleStore srs = new SimpleRuleStore((Context)new ContextBase());
        srs.addRule(new Pattern("a/b"), (Action)new XAction());
        List r = srs.matchActions(new Pattern("a/b"));
        Assert.assertNotNull((Object)r);
        Assert.assertEquals((long)1L, (long)r.size());
        if (!(r.get(0) instanceof XAction)) {
            Assert.fail((String)"Wrong type");
        }
        srs = new SimpleRuleStore((Context)new ContextBase());
        srs.addRule(new Pattern("a/b"), (Action)new XAction());
        srs.addRule(new Pattern("a/b"), (Action)new YAction());
        r = srs.matchActions(new Pattern("a/b"));
        Assert.assertNotNull((Object)r);
        Assert.assertEquals((long)2L, (long)r.size());
        if (!(r.get(0) instanceof XAction)) {
            Assert.fail((String)"Wrong type");
        }
        if (!(r.get(1) instanceof YAction)) {
            Assert.fail((String)"Wrong type");
        }
    }

    @Test
    public void testSlashSuffix() throws Exception {
        SimpleRuleStore srs = new SimpleRuleStore((Context)new ContextBase());
        Pattern pa = new Pattern("a/");
        srs.addRule(pa, (Action)new XAction());
        List r = srs.matchActions(new Pattern("a"));
        Assert.assertNotNull((Object)r);
        Assert.assertEquals((long)1L, (long)r.size());
        if (!(r.get(0) instanceof XAction)) {
            Assert.fail((String)"Wrong type");
        }
    }

    @Test
    public void testTail1() throws Exception {
        SimpleRuleStore srs = new SimpleRuleStore((Context)new ContextBase());
        srs.addRule(new Pattern("*/b"), (Action)new XAction());
        List r = srs.matchActions(new Pattern("a/b"));
        Assert.assertNotNull((Object)r);
        Assert.assertEquals((long)1L, (long)r.size());
        if (!(r.get(0) instanceof XAction)) {
            Assert.fail((String)"Wrong type");
        }
    }

    @Test
    public void testTail2() throws Exception {
        SimpleRuleStore srs = new SimpleRuleStore((Context)new ContextBase());
        srs.addRule(new Pattern("*/c"), (Action)new XAction());
        List r = srs.matchActions(new Pattern("a/b/c"));
        Assert.assertNotNull((Object)r);
        Assert.assertEquals((long)1L, (long)r.size());
        if (!(r.get(0) instanceof XAction)) {
            Assert.fail((String)"Wrong type");
        }
    }

    @Test
    public void testTail3() throws Exception {
        SimpleRuleStore srs = new SimpleRuleStore((Context)new ContextBase());
        srs.addRule(new Pattern("*/b"), (Action)new XAction());
        srs.addRule(new Pattern("*/a/b"), (Action)new YAction());
        List r = srs.matchActions(new Pattern("a/b"));
        Assert.assertNotNull((Object)r);
        Assert.assertEquals((long)1L, (long)r.size());
        if (!(r.get(0) instanceof YAction)) {
            Assert.fail((String)"Wrong type");
        }
    }

    @Test
    public void testTail4() throws Exception {
        SimpleRuleStore srs = new SimpleRuleStore((Context)new ContextBase());
        srs.addRule(new Pattern("*/b"), (Action)new XAction());
        srs.addRule(new Pattern("*/a/b"), (Action)new YAction());
        srs.addRule(new Pattern("a/b"), (Action)new ZAction());
        List r = srs.matchActions(new Pattern("a/b"));
        Assert.assertNotNull((Object)r);
        Assert.assertEquals((long)1L, (long)r.size());
        if (!(r.get(0) instanceof ZAction)) {
            Assert.fail((String)"Wrong type");
        }
    }

    @Test
    public void testSuffix() throws Exception {
        SimpleRuleStore srs = new SimpleRuleStore((Context)new ContextBase());
        srs.addRule(new Pattern("a"), (Action)new XAction());
        srs.addRule(new Pattern("a/*"), (Action)new YAction());
        List r = srs.matchActions(new Pattern("a/b"));
        Assert.assertNotNull((Object)r);
        Assert.assertEquals((long)1L, (long)r.size());
        Assert.assertTrue((boolean)(r.get(0) instanceof YAction));
    }

    @Test
    public void testDeepSuffix() throws Exception {
        SimpleRuleStore srs = new SimpleRuleStore((Context)new ContextBase());
        srs.addRule(new Pattern("a"), (Action)new XAction(1));
        srs.addRule(new Pattern("a/b/*"), (Action)new XAction(2));
        List r = srs.matchActions(new Pattern("a/other"));
        Assert.assertNull((Object)r);
    }

    @Test
    public void testPrefixSuffixInteraction1() throws Exception {
        SimpleRuleStore srs = new SimpleRuleStore((Context)new ContextBase());
        srs.addRule(new Pattern("a"), (Action)new ZAction());
        srs.addRule(new Pattern("a/*"), (Action)new YAction());
        srs.addRule(new Pattern("*/a/b"), (Action)new XAction(3));
        List r = srs.matchActions(new Pattern("a/b"));
        Assert.assertNotNull((Object)r);
        Assert.assertEquals((long)1L, (long)r.size());
        Assert.assertTrue((boolean)(r.get(0) instanceof XAction));
        XAction xaction = (XAction)((Object)r.get(0));
        Assert.assertEquals((long)3L, (long)xaction.id);
    }

    @Test
    public void testPrefixSuffixInteraction2() throws Exception {
        SimpleRuleStore srs = new SimpleRuleStore((Context)new ContextBase());
        srs.addRule(new Pattern("testGroup"), (Action)new XAction());
        srs.addRule(new Pattern("testGroup/testShell"), (Action)new YAction());
        srs.addRule(new Pattern("testGroup/testShell/test"), (Action)new ZAction());
        srs.addRule(new Pattern("testGroup/testShell/test/*"), (Action)new XAction(9));
        List r = srs.matchActions(new Pattern("testGroup/testShell/toto"));
        Assert.assertNull((Object)r);
    }

    class ZAction
    extends Action {
        ZAction() {
        }

        public void begin(InterpretationContext ec, String name, Attributes attributes) {
        }

        public void end(InterpretationContext ec, String name) {
        }

        public void finish(InterpretationContext ec) {
        }
    }

    class YAction
    extends Action {
        YAction() {
        }

        public void begin(InterpretationContext ec, String name, Attributes attributes) {
        }

        public void end(InterpretationContext ec, String name) {
        }

        public void finish(InterpretationContext ec) {
        }
    }

    class XAction
    extends Action {
        int id = 0;

        XAction() {
        }

        XAction(int id) {
            this.id = id;
        }

        public void begin(InterpretationContext ec, String name, Attributes attributes) {
        }

        public void end(InterpretationContext ec, String name) {
        }

        public void finish(InterpretationContext ec) {
        }

        public String toString() {
            return "XAction(" + this.id + ")";
        }
    }
}

