/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.pattern.parser;

import ch.qos.logback.core.pattern.FormatInfo;
import ch.qos.logback.core.pattern.parser.CompositeNode;
import ch.qos.logback.core.pattern.parser.FormattingNode;
import ch.qos.logback.core.pattern.parser.KeywordNode;
import ch.qos.logback.core.pattern.parser.Node;
import ch.qos.logback.core.pattern.parser.Parser;
import java.util.ArrayList;
import org.junit.Assert;
import org.junit.Test;

public class ParserTest {
    @Test
    public void testBasic() throws Exception {
        Parser p = new Parser("hello");
        Node t = p.parse();
        Assert.assertEquals((long)0L, (long)t.getType());
        Assert.assertEquals((Object)"hello", (Object)t.getValue());
    }

    @Test
    public void testKeyword() throws Exception {
        Parser p = new Parser("hello%xyz");
        Node t = p.parse();
        Node witness = new Node(0, (Object)"hello");
        witness.next = new KeywordNode((Object)"xyz");
        Assert.assertEquals((Object)witness, (Object)t);
        p = new Parser("hello%xyz{x}");
        t = p.parse();
        witness = new Node(0, (Object)"hello");
        KeywordNode n = new KeywordNode((Object)"xyz");
        ArrayList<String> optionList = new ArrayList<String>();
        optionList.add("x");
        n.setOptions(optionList);
        witness.next = n;
        Assert.assertEquals((Object)witness, (Object)t);
    }

    @Test
    public void testComposite() throws Exception {
        Parser p = new Parser("hello%(%child)");
        Node t = p.parse();
        Node witness = new Node(0, (Object)"hello");
        CompositeNode composite = new CompositeNode();
        KeywordNode child = new KeywordNode((Object)"child");
        composite.setChildNode((Node)child);
        witness.next = composite;
        Assert.assertEquals((Object)witness, (Object)t);
        p = new Parser("hello%(%child )");
        t = p.parse();
        witness = new Node(0, (Object)"hello");
        composite = new CompositeNode();
        child = new KeywordNode((Object)"child");
        composite.setChildNode((Node)child);
        witness.next = composite;
        child.next = new Node(0, (Object)" ");
        Assert.assertEquals((Object)witness, (Object)t);
        p = new Parser("hello%(%child %h)");
        t = p.parse();
        witness = new Node(0, (Object)"hello");
        composite = new CompositeNode();
        child = new KeywordNode((Object)"child");
        composite.setChildNode((Node)child);
        child.next = new Node(0, (Object)" ");
        child.next.next = new KeywordNode((Object)"h");
        witness.next = composite;
        Assert.assertEquals((Object)witness, (Object)t);
        p = new Parser("hello%(%child %h) %m");
        t = p.parse();
        witness = new Node(0, (Object)"hello");
        composite = new CompositeNode();
        child = new KeywordNode((Object)"child");
        composite.setChildNode((Node)child);
        child.next = new Node(0, (Object)" ");
        child.next.next = new KeywordNode((Object)"h");
        witness.next = composite;
        composite.next = new Node(0, (Object)" ");
        composite.next.next = new KeywordNode((Object)"m");
        Assert.assertEquals((Object)witness, (Object)t);
        p = new Parser("hello%( %child \\(%h\\) ) %m");
        t = p.parse();
        witness = new Node(0, (Object)"hello");
        composite = new CompositeNode();
        child = new Node(0, (Object)" ");
        composite.setChildNode((Node)child);
        KeywordNode c = child;
        c.next = new KeywordNode((Object)"child");
        c = c.next;
        c.next = new Node(0, (Object)" (");
        c = c.next;
        c.next = new KeywordNode((Object)"h");
        c = c.next;
        c.next = new Node(0, (Object)") ");
        c = c.next;
        witness.next = composite;
        composite.next = new Node(0, (Object)" ");
        composite.next.next = new KeywordNode((Object)"m");
        Assert.assertEquals((Object)witness, (Object)t);
    }

    @Test
    public void testNested() throws Exception {
        Parser p = new Parser("%top %(%child%(%h))");
        Node t = p.parse();
        KeywordNode witness = new KeywordNode((Object)"top");
        Node w = witness.next = new Node(0, (Object)" ");
        CompositeNode composite = new CompositeNode();
        w = w.next = composite;
        KeywordNode child = new KeywordNode((Object)"child");
        composite.setChildNode((Node)child);
        composite = new CompositeNode();
        child.next = composite;
        composite.setChildNode((Node)new KeywordNode((Object)"h"));
        Assert.assertEquals((Object)witness, (Object)t);
    }

    @Test
    public void testFormattingInfo() throws Exception {
        Parser p = new Parser("%45x");
        Node t = p.parse();
        KeywordNode witness = new KeywordNode((Object)"x");
        witness.setFormatInfo(new FormatInfo(45, Integer.MAX_VALUE));
        Assert.assertEquals((Object)witness, (Object)t);
        p = new Parser("%4.5x");
        t = p.parse();
        witness = new KeywordNode((Object)"x");
        witness.setFormatInfo(new FormatInfo(4, 5));
        Assert.assertEquals((Object)witness, (Object)t);
        p = new Parser("%-4.5x");
        t = p.parse();
        witness = new KeywordNode((Object)"x");
        witness.setFormatInfo(new FormatInfo(4, 5, false, true));
        Assert.assertEquals((Object)witness, (Object)t);
        p = new Parser("%-4.-5x");
        t = p.parse();
        witness = new KeywordNode((Object)"x");
        witness.setFormatInfo(new FormatInfo(4, 5, false, false));
        Assert.assertEquals((Object)witness, (Object)t);
        p = new Parser("%-4.5x %12y");
        t = p.parse();
        witness = new KeywordNode((Object)"x");
        witness.setFormatInfo(new FormatInfo(4, 5, false, true));
        Node n = witness.next = new Node(0, (Object)" ");
        n = n.next = new KeywordNode((Object)"y");
        ((FormattingNode)n).setFormatInfo(new FormatInfo(12, Integer.MAX_VALUE));
        Assert.assertEquals((Object)witness, (Object)t);
    }

    @Test
    public void testOptions() throws Exception {
        Parser p = new Parser("%45x{'test '}");
        Node t = p.parse();
        KeywordNode witness = new KeywordNode((Object)"x");
        witness.setFormatInfo(new FormatInfo(45, Integer.MAX_VALUE));
        ArrayList<String> ol = new ArrayList<String>();
        ol.add("test ");
        witness.setOptions(ol);
        Assert.assertEquals((Object)witness, (Object)t);
        p = new Parser("%45x{a, b}");
        t = p.parse();
        witness = new KeywordNode((Object)"x");
        witness.setFormatInfo(new FormatInfo(45, Integer.MAX_VALUE));
        ol = new ArrayList();
        ol.add("a");
        ol.add("b");
        witness.setOptions(ol);
        Assert.assertEquals((Object)witness, (Object)t);
    }

    @Test
    public void testCompositeFormatting() throws Exception {
        Parser p = new Parser("hello%5(XYZ)");
        Node t = p.parse();
        Node witness = new Node(0, (Object)"hello");
        CompositeNode composite = new CompositeNode();
        composite.setFormatInfo(new FormatInfo(5, Integer.MAX_VALUE));
        Node child = new Node(0, (Object)"XYZ");
        composite.setChildNode(child);
        witness.next = composite;
        Assert.assertEquals((Object)witness, (Object)t);
    }
}

