/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.rolling.helper;

import ch.qos.logback.core.Context;
import ch.qos.logback.core.ContextBase;
import ch.qos.logback.core.rolling.helper.FileNamePattern;
import ch.qos.logback.core.status.StatusManager;
import ch.qos.logback.core.util.StatusPrinter;
import java.util.Calendar;
import org.junit.Assert;
import org.junit.Test;

public class FileNamePatternTest {
    Context context = new ContextBase();

    @Test
    public void testSmoke() {
        FileNamePattern pp = new FileNamePattern("t", this.context);
        Assert.assertEquals((Object)"t", (Object)pp.convertInt(3));
        pp = new FileNamePattern("foo", this.context);
        Assert.assertEquals((Object)"foo", (Object)pp.convertInt(3));
        pp = new FileNamePattern("%i foo", this.context);
        StatusPrinter.print((StatusManager)this.context.getStatusManager());
        Assert.assertEquals((Object)"3 foo", (Object)pp.convertInt(3));
        pp = new FileNamePattern("foo%i.xixo", this.context);
        Assert.assertEquals((Object)"foo3.xixo", (Object)pp.convertInt(3));
        pp = new FileNamePattern("foo%i.log", this.context);
        Assert.assertEquals((Object)"foo3.log", (Object)pp.convertInt(3));
        pp = new FileNamePattern("foo.%i.log", this.context);
        Assert.assertEquals((Object)"foo.3.log", (Object)pp.convertInt(3));
        pp = new FileNamePattern("%i.foo\\%", this.context);
        Assert.assertEquals((Object)"3.foo%", (Object)pp.convertInt(3));
        pp = new FileNamePattern("\\%foo", this.context);
        Assert.assertEquals((Object)"%foo", (Object)pp.convertInt(3));
    }

    @Test
    public void testFlowingI() {
        FileNamePattern pp = new FileNamePattern("foo%i{}bar%i", this.context);
        Assert.assertEquals((Object)"foo3bar3", (Object)pp.convertInt(3));
        pp = new FileNamePattern("foo%i{}bar%i", this.context);
        Assert.assertEquals((Object)"foo3bar3", (Object)pp.convertInt(3));
    }

    @Test
    public void testDate() {
        Calendar cal = Calendar.getInstance();
        cal.set(2003, 4, 20, 17, 55);
        FileNamePattern pp = new FileNamePattern("foo%d{yyyy.MM.dd}", this.context);
        StatusPrinter.print((StatusManager)this.context.getStatusManager());
        Assert.assertEquals((Object)"foo2003.05.20", (Object)pp.convertDate(cal.getTime()));
        pp = new FileNamePattern("foo%d{yyyy.MM.dd HH:mm}", this.context);
        Assert.assertEquals((Object)"foo2003.05.20 17:55", (Object)pp.convertDate(cal.getTime()));
        pp = new FileNamePattern("%d{yyyy.MM.dd HH:mm} foo", this.context);
        Assert.assertEquals((Object)"2003.05.20 17:55 foo", (Object)pp.convertDate(cal.getTime()));
    }

    @Test
    public void testWithBackslash() {
        FileNamePattern pp = new FileNamePattern("c:\\foo\\bar.%i", this.context);
        Assert.assertEquals((Object)"c:\\foo\\bar.3", (Object)pp.convertInt(3));
    }
}

