/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.sift.tracker;

import ch.qos.logback.core.Appender;
import ch.qos.logback.core.sift.AppenderTracker;
import ch.qos.logback.core.sift.tracker.TEntry;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AppenderTrackerTImpl
implements AppenderTracker<Object> {
    List<TEntry> entryList = new LinkedList<TEntry>();
    long lastCheck = 0L;

    public synchronized void put(String k, Appender<Object> appender, long timestamp) {
        TEntry te = this.getEntry(k);
        if (te != null) {
            te.timestamp = timestamp;
        } else {
            te = new TEntry(k, appender, timestamp);
            this.entryList.add(te);
        }
        Collections.sort(this.entryList);
    }

    public synchronized Appender<Object> get(String k, long timestamp) {
        TEntry te = this.getEntry(k);
        if (te == null) {
            return null;
        }
        te.timestamp = timestamp;
        Collections.sort(this.entryList);
        return te.appender;
    }

    public synchronized void stopStaleAppenders(long timestamp) {
        if (this.lastCheck + 1000L > timestamp) {
            return;
        }
        this.lastCheck = timestamp;
        while (this.entryList.size() != 0 && this.isEntryStale(this.entryList.get(0), timestamp)) {
            this.entryList.remove(0);
        }
    }

    private final boolean isEntryStale(TEntry entry, long now) {
        return entry.timestamp + 1800000L < now;
    }

    public synchronized List<String> keyList() {
        ArrayList<String> keyList = new ArrayList<String>();
        for (TEntry e : this.entryList) {
            keyList.add(e.key);
        }
        return keyList;
    }

    public synchronized List<Appender<Object>> valueList() {
        ArrayList<Appender<Object>> appenderList = new ArrayList<Appender<Object>>();
        for (TEntry e : this.entryList) {
            appenderList.add(e.appender);
        }
        return appenderList;
    }

    private TEntry getEntry(String k) {
        for (int i = 0; i < this.entryList.size(); ++i) {
            TEntry te = this.entryList.get(i);
            if (!te.key.equals(k)) continue;
            return te;
        }
        return null;
    }
}

