/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.appender;

import ch.qos.logback.core.AppenderBase;
import ch.qos.logback.core.ConsoleAppender;
import ch.qos.logback.core.CoreConstants;
import ch.qos.logback.core.appender.AbstractAppenderTest;
import ch.qos.logback.core.layout.DummyLayout;
import ch.qos.logback.core.layout.NopLayout;
import ch.qos.logback.core.util.TeeOutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConsoleAppenderTest
extends AbstractAppenderTest<Object> {
    TeeOutputStream tee;
    PrintStream original;

    @Before
    public void setUp() throws Exception {
        this.original = System.out;
        this.tee = new TeeOutputStream(null);
        System.setOut(new PrintStream(this.tee));
    }

    @After
    public void tearDown() throws Exception {
        System.setOut(this.original);
    }

    @Override
    public AppenderBase<Object> getAppender() {
        return new ConsoleAppender();
    }

    @Override
    protected AppenderBase<Object> getConfiguredAppender() {
        ConsoleAppender ca = new ConsoleAppender();
        ca.setLayout(new NopLayout());
        ca.start();
        return ca;
    }

    @Test
    public void testBasic() {
        ConsoleAppender ca = (ConsoleAppender)this.getAppender();
        ca.setLayout(new DummyLayout());
        ca.start();
        ca.doAppend(new Object());
        Assert.assertEquals((Object)DummyLayout.DUMMY, (Object)this.tee.toString());
    }

    @Test
    public void testOpen() {
        ConsoleAppender ca = (ConsoleAppender)this.getAppender();
        DummyLayout dummyLayout = new DummyLayout();
        dummyLayout.setFileHeader("open");
        ca.setLayout(dummyLayout);
        ca.start();
        ca.doAppend(new Object());
        ca.stop();
        Assert.assertEquals((Object)("open" + CoreConstants.LINE_SEPARATOR + DummyLayout.DUMMY), (Object)this.tee.toString());
    }

    @Test
    public void testClose() {
        ConsoleAppender ca = (ConsoleAppender)this.getAppender();
        DummyLayout dummyLayout = new DummyLayout();
        dummyLayout.setFileFooter("CLOSED");
        ca.setLayout(dummyLayout);
        ca.start();
        ca.doAppend(new Object());
        ca.stop();
        Assert.assertEquals((Object)(DummyLayout.DUMMY + "CLOSED"), (Object)this.tee.toString());
    }

    @Test
    public void testUTF16BE() throws UnsupportedEncodingException {
        ConsoleAppender ca = (ConsoleAppender)this.getAppender();
        ca.setLayout(new DummyLayout());
        String encodingName = "UTF-16BE";
        ca.setEncoding(encodingName);
        ca.start();
        ca.doAppend(new Object());
        Assert.assertEquals((Object)DummyLayout.DUMMY, (Object)new String(this.tee.toByteArray(), encodingName));
    }
}

