/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.joran.action;

import ch.qos.logback.core.Context;
import ch.qos.logback.core.ContextBase;
import ch.qos.logback.core.joran.action.DummyAttributes;
import ch.qos.logback.core.joran.action.PropertyAction;
import ch.qos.logback.core.joran.spi.InterpretationContext;
import ch.qos.logback.core.status.ErrorStatus;
import ch.qos.logback.core.util.StatusPrinter;
import java.util.Iterator;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.xml.sax.Attributes;

public class PropertyActionTest {
    Context context;
    InterpretationContext ec;
    PropertyAction spAction;
    DummyAttributes atts = new DummyAttributes();

    @Before
    public void setUp() throws Exception {
        this.context = new ContextBase();
        this.ec = new InterpretationContext(this.context, null);
        this.spAction = new PropertyAction();
        this.spAction.setContext(this.context);
    }

    @After
    public void tearDown() throws Exception {
        this.context = null;
        this.spAction = null;
        this.atts = null;
    }

    @Test
    public void nameValuePair() {
        this.atts.setValue("name", "v1");
        this.atts.setValue("value", "work");
        this.spAction.begin(this.ec, null, (Attributes)this.atts);
        Assert.assertEquals((Object)"work", (Object)this.ec.getProperty("v1"));
    }

    @Test
    public void nameValuePairWithPrerequisiteSubsitution() {
        this.context.putProperty("w", "wor");
        this.atts.setValue("name", "v1");
        this.atts.setValue("value", "${w}k");
        this.spAction.begin(this.ec, null, (Attributes)this.atts);
        Assert.assertEquals((Object)"work", (Object)this.ec.getProperty("v1"));
    }

    @Test
    public void noValue() {
        this.atts.setValue("name", "v1");
        this.spAction.begin(this.ec, null, (Attributes)this.atts);
        Assert.assertEquals((long)1L, (long)this.context.getStatusManager().getCount());
        Assert.assertTrue((boolean)this.checkError());
    }

    @Test
    public void noName() {
        this.atts.setValue("value", "v1");
        this.spAction.begin(this.ec, null, (Attributes)this.atts);
        Assert.assertEquals((long)1L, (long)this.context.getStatusManager().getCount());
        Assert.assertTrue((boolean)this.checkError());
    }

    @Test
    public void noAttributes() {
        this.spAction.begin(this.ec, null, (Attributes)this.atts);
        Assert.assertEquals((long)1L, (long)this.context.getStatusManager().getCount());
        Assert.assertTrue((boolean)this.checkError());
        StatusPrinter.print((Context)this.context);
    }

    @Test
    public void testFileNotLoaded() {
        this.atts.setValue("file", "toto");
        this.atts.setValue("value", "work");
        this.spAction.begin(this.ec, null, (Attributes)this.atts);
        Assert.assertEquals((long)1L, (long)this.context.getStatusManager().getCount());
        Assert.assertTrue((boolean)this.checkError());
    }

    @Test
    public void testLoadFileWithPrerequisiteSubsitution() {
        this.context.putProperty("STEM", "src/test/input/joran");
        this.atts.setValue("file", "${STEM}/propertyActionTest.properties");
        this.spAction.begin(this.ec, null, (Attributes)this.atts);
        Assert.assertEquals((Object)"tata", (Object)this.ec.getProperty("v1"));
        Assert.assertEquals((Object)"toto", (Object)this.ec.getProperty("v2"));
    }

    @Test
    public void testLoadFile() {
        this.atts.setValue("file", "src/test/input/joran/propertyActionTest.properties");
        this.spAction.begin(this.ec, null, (Attributes)this.atts);
        Assert.assertEquals((Object)"tata", (Object)this.ec.getProperty("v1"));
        Assert.assertEquals((Object)"toto", (Object)this.ec.getProperty("v2"));
    }

    @Test
    public void testLoadResource() {
        this.atts.setValue("resource", "asResource/joran/propertyActionTest.properties");
        this.spAction.begin(this.ec, null, (Attributes)this.atts);
        Assert.assertEquals((Object)"tata", (Object)this.ec.getProperty("r1"));
        Assert.assertEquals((Object)"toto", (Object)this.ec.getProperty("r2"));
    }

    @Test
    public void testLoadResourceWithPrerequisiteSubsitution() {
        this.context.putProperty("STEM", "asResource/joran");
        this.atts.setValue("resource", "${STEM}/propertyActionTest.properties");
        this.spAction.begin(this.ec, null, (Attributes)this.atts);
        Assert.assertEquals((Object)"tata", (Object)this.ec.getProperty("r1"));
        Assert.assertEquals((Object)"toto", (Object)this.ec.getProperty("r2"));
    }

    @Test
    public void testLoadNotPossible() {
        this.atts.setValue("file", "toto");
        this.spAction.begin(this.ec, null, (Attributes)this.atts);
        Assert.assertEquals((long)1L, (long)this.context.getStatusManager().getCount());
        Assert.assertTrue((boolean)this.checkFileErrors());
    }

    private boolean checkError() {
        Iterator it = this.context.getStatusManager().getCopyOfStatusList().iterator();
        ErrorStatus es = (ErrorStatus)it.next();
        return PropertyAction.INVALID_ATTRIBUTES.equals(es.getMessage());
    }

    private boolean checkFileErrors() {
        Iterator it = this.context.getStatusManager().getCopyOfStatusList().iterator();
        ErrorStatus es1 = (ErrorStatus)it.next();
        return "Could not read properties file [toto].".equals(es1.getMessage());
    }
}

