/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.joran.spi;

import ch.qos.logback.core.Context;
import ch.qos.logback.core.ContextBase;
import ch.qos.logback.core.joran.spi.DefaultNestedComponentRegistry;
import ch.qos.logback.core.joran.spi.Door;
import ch.qos.logback.core.joran.spi.House;
import ch.qos.logback.core.joran.spi.HouseColor;
import ch.qos.logback.core.joran.spi.LargeSwimmingPoolImpl;
import ch.qos.logback.core.joran.spi.PropertySetter;
import ch.qos.logback.core.joran.spi.SwimmingPoolImpl;
import ch.qos.logback.core.joran.spi.Window;
import ch.qos.logback.core.spi.FilterReply;
import ch.qos.logback.core.util.AggregationType;
import java.lang.reflect.Method;
import org.junit.Assert;
import org.junit.Test;

public class PropertySetterTest {
    DefaultNestedComponentRegistry defaultComponentRegistry = new DefaultNestedComponentRegistry();

    @Test
    public void testCanAggregateComponent() {
        House house = new House();
        PropertySetter setter = new PropertySetter((Object)house);
        Assert.assertEquals((Object)AggregationType.AS_COMPLEX_PROPERTY, (Object)setter.computeAggregationType("door"));
        Assert.assertEquals((Object)AggregationType.AS_BASIC_PROPERTY, (Object)setter.computeAggregationType("count"));
        Assert.assertEquals((Object)AggregationType.AS_BASIC_PROPERTY, (Object)setter.computeAggregationType("Count"));
        Assert.assertEquals((Object)AggregationType.AS_BASIC_PROPERTY, (Object)setter.computeAggregationType("name"));
        Assert.assertEquals((Object)AggregationType.AS_BASIC_PROPERTY, (Object)setter.computeAggregationType("Name"));
        Assert.assertEquals((Object)AggregationType.AS_BASIC_PROPERTY, (Object)setter.computeAggregationType("Duration"));
        Assert.assertEquals((Object)AggregationType.AS_BASIC_PROPERTY, (Object)setter.computeAggregationType("fs"));
        Assert.assertEquals((Object)AggregationType.AS_BASIC_PROPERTY, (Object)setter.computeAggregationType("open"));
        Assert.assertEquals((Object)AggregationType.AS_BASIC_PROPERTY, (Object)setter.computeAggregationType("Open"));
        Assert.assertEquals((Object)AggregationType.AS_COMPLEX_PROPERTY_COLLECTION, (Object)setter.computeAggregationType("Window"));
        Assert.assertEquals((Object)AggregationType.AS_BASIC_PROPERTY_COLLECTION, (Object)setter.computeAggregationType("adjective"));
        Assert.assertEquals((Object)AggregationType.AS_BASIC_PROPERTY, (Object)setter.computeAggregationType("filterReply"));
        Assert.assertEquals((Object)AggregationType.AS_BASIC_PROPERTY, (Object)setter.computeAggregationType("houseColor"));
        System.out.println();
    }

    @Test
    public void testSetProperty() {
        House house = new House();
        PropertySetter setter = new PropertySetter((Object)house);
        setter.setProperty("count", "10");
        setter.setProperty("name", "jack");
        setter.setProperty("open", "true");
        Assert.assertEquals((long)10L, (long)house.getCount());
        Assert.assertEquals((Object)"jack", (Object)house.getName());
        Assert.assertTrue((boolean)house.isOpen());
        house = new House();
        setter = new PropertySetter((Object)house);
        setter.setProperty("Count", "10");
        setter.setProperty("Name", "jack");
        setter.setProperty("Open", "true");
        Assert.assertEquals((long)10L, (long)house.getCount());
        Assert.assertEquals((Object)"jack", (Object)house.getName());
        Assert.assertTrue((boolean)house.isOpen());
    }

    @Test
    public void testSetCamelProperty() {
        House house = new House();
        PropertySetter setter = new PropertySetter((Object)house);
        setter.setProperty("camelCase", "trot");
        Assert.assertEquals((Object)"trot", (Object)house.getCamelCase());
        setter.setProperty("camelCase", "gh");
        Assert.assertEquals((Object)"gh", (Object)house.getCamelCase());
    }

    @Test
    public void testSetComplexProperty() {
        House house = new House();
        Door door = new Door();
        PropertySetter setter = new PropertySetter((Object)house);
        setter.setComplexProperty("door", (Object)door);
        Assert.assertEquals((Object)door, (Object)house.getDoor());
    }

    @Test
    public void testgetClassNameViaImplicitRules() {
        House house = new House();
        PropertySetter setter = new PropertySetter((Object)house);
        Class compClass = setter.getClassNameViaImplicitRules("door", AggregationType.AS_COMPLEX_PROPERTY, this.defaultComponentRegistry);
        Assert.assertEquals(Door.class, (Object)compClass);
    }

    @Test
    public void testgetComplexPropertyColleClassNameViaImplicitRules() {
        House house = new House();
        PropertySetter setter = new PropertySetter((Object)house);
        Class compClass = setter.getClassNameViaImplicitRules("window", AggregationType.AS_COMPLEX_PROPERTY_COLLECTION, this.defaultComponentRegistry);
        Assert.assertEquals(Window.class, (Object)compClass);
    }

    @Test
    public void testPropertyCollection() {
        House house = new House();
        ContextBase context = new ContextBase();
        PropertySetter setter = new PropertySetter((Object)house);
        setter.setContext((Context)context);
        setter.addBasicProperty("adjective", "nice");
        setter.addBasicProperty("adjective", "big");
        Assert.assertEquals((long)2L, (long)house.adjectiveList.size());
        Assert.assertEquals((Object)"nice", (Object)house.adjectiveList.get(0));
        Assert.assertEquals((Object)"big", (Object)house.adjectiveList.get(1));
    }

    @Test
    public void testComplexCollection() {
        House house = new House();
        PropertySetter setter = new PropertySetter((Object)house);
        Window w1 = new Window();
        w1.handle = 10;
        Window w2 = new Window();
        w2.handle = 20;
        setter.addComplexProperty("window", (Object)w1);
        setter.addComplexProperty("window", (Object)w2);
        Assert.assertEquals((long)2L, (long)house.windowList.size());
        Assert.assertEquals((long)10L, (long)house.windowList.get((int)0).handle);
        Assert.assertEquals((long)20L, (long)house.windowList.get((int)1).handle);
    }

    @Test
    public void testSetComplexWithCamelCaseName() {
        House house = new House();
        SwimmingPoolImpl pool = new SwimmingPoolImpl();
        PropertySetter setter = new PropertySetter((Object)house);
        setter.setComplexProperty("swimmingPool", (Object)pool);
        Assert.assertEquals((Object)pool, (Object)house.getSwimmingPool());
    }

    @Test
    public void testDuration() {
        House house = new House();
        PropertySetter setter = new PropertySetter((Object)house);
        setter.setProperty("duration", "1.4 seconds");
        Assert.assertEquals((long)1400L, (long)house.getDuration().getMilliseconds());
    }

    @Test
    public void testFileSize() {
        House house = new House();
        PropertySetter setter = new PropertySetter((Object)house);
        setter.setProperty("fs", "2 kb");
        Assert.assertEquals((long)2048L, (long)house.getFs().getSize());
    }

    @Test
    public void testFilterReply() {
        House house = new House();
        PropertySetter setter = new PropertySetter((Object)house);
        setter.setProperty("filterReply", "ACCEPT");
        Assert.assertEquals((Object)FilterReply.ACCEPT, (Object)house.getFilterReply());
    }

    @Test
    public void testEnum() {
        House house = new House();
        PropertySetter setter = new PropertySetter((Object)house);
        setter.setProperty("houseColor", "BLUE");
        Assert.assertEquals((Object)((Object)HouseColor.BLUE), (Object)((Object)house.getHouseColor()));
    }

    @Test
    public void testDefaultClassAnnonation() {
        House house = new House();
        PropertySetter setter = new PropertySetter((Object)house);
        Method relevantMethod = setter.getRelevantMethod("SwimmingPool", AggregationType.AS_COMPLEX_PROPERTY);
        Assert.assertNotNull((Object)relevantMethod);
        Class spClass = setter.getDefaultClassNameByAnnonation("SwimmingPool", relevantMethod);
        Assert.assertEquals(SwimmingPoolImpl.class, (Object)spClass);
        Class classViaImplicitRules = setter.getClassNameViaImplicitRules("SwimmingPool", AggregationType.AS_COMPLEX_PROPERTY, this.defaultComponentRegistry);
        Assert.assertEquals(SwimmingPoolImpl.class, (Object)classViaImplicitRules);
    }

    @Test
    public void testDefaultClassAnnotationForLists() {
        House house = new House();
        PropertySetter setter = new PropertySetter((Object)house);
        Method relevantMethod = setter.getRelevantMethod("LargeSwimmingPool", AggregationType.AS_COMPLEX_PROPERTY_COLLECTION);
        Assert.assertNotNull((Object)relevantMethod);
        Class spClass = setter.getDefaultClassNameByAnnonation("LargeSwimmingPool", relevantMethod);
        Assert.assertEquals(LargeSwimmingPoolImpl.class, (Object)spClass);
        Class classViaImplicitRules = setter.getClassNameViaImplicitRules("LargeSwimmingPool", AggregationType.AS_COMPLEX_PROPERTY_COLLECTION, this.defaultComponentRegistry);
        Assert.assertEquals(LargeSwimmingPoolImpl.class, (Object)classViaImplicitRules);
    }
}

