/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.sift;

import ch.qos.logback.core.Context;
import ch.qos.logback.core.ContextBase;
import ch.qos.logback.core.read.ListAppender;
import ch.qos.logback.core.sift.AppenderTracker;
import ch.qos.logback.core.sift.AppenderTrackerImpl;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class AppenderTrackerTest {
    Context context = new ContextBase();
    AppenderTracker<Object> appenderTracker = new AppenderTrackerImpl();
    ListAppender<Object> la = new ListAppender();

    @Before
    public void setUp() {
        this.la.setContext(this.context);
        this.la.start();
    }

    @Test
    public void empty0() {
        long now = 3000L;
        this.appenderTracker.stopStaleAppenders(now);
        Assert.assertEquals((long)0L, (long)this.appenderTracker.keyList().size());
    }

    @Test
    public void empty1() {
        long now = 3000L;
        Assert.assertNull((Object)this.appenderTracker.get("a", now++));
        this.appenderTracker.stopStaleAppenders(now += 1801000L);
        Assert.assertNull((Object)this.appenderTracker.get("a", now++));
    }

    @Test
    public void smoke() {
        Assert.assertTrue((boolean)this.la.isStarted());
        long now = 3000L;
        this.appenderTracker.put("a", this.la, now);
        Assert.assertEquals(this.la, (Object)this.appenderTracker.get("a", now++));
        this.appenderTracker.stopStaleAppenders(now += 1801000L);
        Assert.assertFalse((boolean)this.la.isStarted());
        Assert.assertNull((Object)this.appenderTracker.get("a", now++));
    }

    @Test
    public void scenarioBased() {
    }
}

