/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.rolling;

import ch.qos.logback.core.Appender;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.ContextBase;
import ch.qos.logback.core.appender.AbstractAppenderTest;
import ch.qos.logback.core.layout.DummyLayout;
import ch.qos.logback.core.rolling.RollingFileAppender;
import ch.qos.logback.core.rolling.SizeBasedTriggeringPolicy;
import ch.qos.logback.core.rolling.TimeBasedRollingPolicy;
import ch.qos.logback.core.rolling.TriggeringPolicy;
import ch.qos.logback.core.status.StatusChecker;
import ch.qos.logback.core.status.StatusManager;
import ch.qos.logback.core.util.StatusPrinter;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RollingFileAppenderTest
extends AbstractAppenderTest<Object> {
    RollingFileAppender<Object> rfa = new RollingFileAppender();
    Context context = new ContextBase();
    TimeBasedRollingPolicy<Object> tbrp = new TimeBasedRollingPolicy();

    @Before
    public void setUp() throws Exception {
        this.rfa.setLayout(new DummyLayout());
        this.rfa.setName("test");
        this.tbrp.setContext(this.context);
        this.tbrp.setParent(this.rfa);
    }

    @After
    public void tearDown() throws Exception {
    }

    @Override
    protected Appender<Object> getAppender() {
        return this.rfa;
    }

    @Override
    protected Appender<Object> getConfiguredAppender() {
        this.rfa.setContext(this.context);
        this.tbrp.setFileNamePattern("toto-%d.log");
        this.tbrp.start();
        this.rfa.setRollingPolicy(this.tbrp);
        this.rfa.start();
        return this.rfa;
    }

    @Test
    public void testPrudentModeLogicalImplications() {
        this.rfa.setContext(this.context);
        this.rfa.setFile("some non null value");
        this.rfa.setAppend(false);
        this.rfa.setImmediateFlush(false);
        this.rfa.setBufferedIO(true);
        this.rfa.setPrudent(true);
        this.tbrp.setFileNamePattern("toto-%d.log");
        this.tbrp.start();
        this.rfa.setRollingPolicy(this.tbrp);
        this.rfa.start();
        Assert.assertTrue((boolean)this.rfa.getImmediateFlush());
        Assert.assertTrue((boolean)this.rfa.isAppend());
        Assert.assertFalse((boolean)this.rfa.isBufferedIO());
        Assert.assertNull((Object)this.rfa.rawFileProperty());
        Assert.assertTrue((boolean)this.rfa.isStarted());
    }

    @Test
    public void testPrudentModeLogicalImplicationsOnCompression() {
        this.rfa.setContext(this.context);
        this.rfa.setAppend(false);
        this.rfa.setImmediateFlush(false);
        this.rfa.setBufferedIO(true);
        this.rfa.setPrudent(true);
        this.tbrp.setFileNamePattern("toto-%d.log.zip");
        this.tbrp.start();
        this.rfa.setRollingPolicy(this.tbrp);
        this.rfa.start();
        StatusManager sm = this.context.getStatusManager();
        Assert.assertFalse((boolean)this.rfa.isStarted());
        Assert.assertEquals((long)2L, (long)sm.getLevel());
    }

    @Test
    public void testFilePropertyAfterRollingPolicy() {
        this.rfa.setContext(this.context);
        this.rfa.setRollingPolicy(this.tbrp);
        this.rfa.setFile("x");
        StatusPrinter.print((Context)this.context);
        StatusChecker statusChecker = new StatusChecker(this.context.getStatusManager());
        statusChecker.containsMatch(2, "File property must be set before any triggeringPolicy ");
    }

    @Test
    public void testFilePropertyAfterTriggeringPolicy() {
        this.rfa.setContext(this.context);
        this.rfa.setTriggeringPolicy((TriggeringPolicy)new SizeBasedTriggeringPolicy());
        this.rfa.setFile("x");
        StatusChecker statusChecker = new StatusChecker(this.context.getStatusManager());
        statusChecker.containsMatch(2, "File property must be set before any triggeringPolicy ");
    }
}

