/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.sift;

import ch.qos.logback.core.appender.NOPAppender;
import ch.qos.logback.core.sift.AppenderTracker;
import ch.qos.logback.core.sift.AppenderTrackerImpl;
import ch.qos.logback.core.sift.tracker.AppenderTrackerTImpl;
import ch.qos.logback.core.sift.tracker.SimulationEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Random;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Simulator {
    AppenderTrackerImpl<Object> appenderTracker = new AppenderTrackerImpl();
    AppenderTrackerTImpl t_appenderTracker = new AppenderTrackerTImpl();
    List<String> keySpace = new ArrayList<String>();
    List<SimulationEvent> scenario = new ArrayList<SimulationEvent>();
    Random randomKeyGen = new Random(100L);
    Random random = new Random(11234L);
    final int maxTimestampInc;
    long timestamp = 30000L;

    Simulator(int keySpaceLen, int maxTimestampInc) {
        this.maxTimestampInc = maxTimestampInc;
        HashMap<String, String> checkMap = new HashMap<String, String>();
        for (int i = 0; i < keySpaceLen; ++i) {
            String k = this.getRandomKeyStr();
            if (checkMap.containsKey(k)) {
                System.out.println("random key collision occured");
                k = k + "" + i;
            }
            this.keySpace.add(k);
            checkMap.put(k, k);
        }
    }

    private String getRandomKeyStr() {
        int ri = this.randomKeyGen.nextInt();
        String s = String.format("%X", ri);
        return s;
    }

    void buildScenario(int simLen) {
        int keySpaceLen = this.keySpace.size();
        for (int i = 0; i < simLen; ++i) {
            int index = this.random.nextInt(keySpaceLen);
            this.timestamp += (long)this.random.nextInt(this.maxTimestampInc);
            String key = this.keySpace.get(index);
            this.scenario.add(new SimulationEvent(key, this.timestamp));
        }
    }

    public void simulate() {
        for (SimulationEvent simeEvent : this.scenario) {
            this.play(simeEvent, (AppenderTracker<Object>)this.appenderTracker);
            this.play(simeEvent, this.t_appenderTracker);
        }
    }

    void play(SimulationEvent simulationEvent, AppenderTracker<Object> appenderTracker) {
        String mdcValue = simulationEvent.key;
        long timestamp = simulationEvent.timestamp;
        Object appender = appenderTracker.get(mdcValue, timestamp);
        if (appender == null) {
            appender = new NOPAppender();
            appenderTracker.put(mdcValue, appender, timestamp);
        }
        appenderTracker.stopStaleAppenders(timestamp);
    }
}

