/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.status;

import ch.qos.logback.core.Context;
import ch.qos.logback.core.status.Status;
import ch.qos.logback.core.status.StatusManager;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StatusChecker {
    StatusManager sm;

    public StatusChecker(StatusManager sm) {
        this.sm = sm;
    }

    public StatusChecker(Context context) {
        this.sm = context.getStatusManager();
    }

    public boolean isErrorFree() {
        int level = this.sm.getLevel();
        return level < 2;
    }

    public boolean containsMatch(int level, String regex) {
        Pattern p = Pattern.compile(regex);
        for (Status status : this.sm.getCopyOfStatusList()) {
            String msg;
            Matcher matcher;
            if (level != status.getLevel() || !(matcher = p.matcher(msg = status.getMessage())).lookingAt()) continue;
            return true;
        }
        return false;
    }

    public boolean containsMatch(String regex) {
        Pattern p = Pattern.compile(regex);
        for (Status status : this.sm.getCopyOfStatusList()) {
            String msg = status.getMessage();
            Matcher matcher = p.matcher(msg);
            if (!matcher.lookingAt()) continue;
            return true;
        }
        return false;
    }

    public int matchCount(String regex) {
        int count = 0;
        Pattern p = Pattern.compile(regex);
        for (Status status : this.sm.getCopyOfStatusList()) {
            String msg = status.getMessage();
            Matcher matcher = p.matcher(msg);
            if (!matcher.lookingAt()) continue;
            ++count;
        }
        return count;
    }

    public boolean containsException(Class exceptionType) {
        for (Status status : this.sm.getCopyOfStatusList()) {
            Throwable t = status.getThrowable();
            if (t == null || !t.getClass().getName().equals(exceptionType.getName())) continue;
            return true;
        }
        return false;
    }
}

