/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.appender;

import ch.qos.logback.core.Appender;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.ContextBase;
import ch.qos.logback.core.status.StatusChecker;
import org.junit.Assert;
import org.junit.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractAppenderTest<E> {
    protected abstract Appender<E> getAppender();

    protected abstract Appender<E> getConfiguredAppender();

    @Test
    public void testNewAppender() {
        Appender<E> appender = this.getAppender();
        Assert.assertFalse((boolean)appender.isStarted());
    }

    @Test
    public void testConfiguredAppender() {
        Appender<E> appender = this.getConfiguredAppender();
        appender.start();
        Assert.assertTrue((boolean)appender.isStarted());
        appender.stop();
        Assert.assertFalse((boolean)appender.isStarted());
    }

    @Test
    public void testNoStart() {
        Appender<E> appender = this.getAppender();
        ContextBase context = new ContextBase();
        appender.setContext((Context)context);
        appender.setName("doh");
        appender.doAppend(null);
        StatusChecker checker = new StatusChecker(context.getStatusManager());
        Assert.assertTrue((boolean)checker.containsMatch("Attempted to append to non started appender \\[doh\\]."));
    }
}

