/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.rolling;

import ch.qos.logback.core.Context;
import ch.qos.logback.core.ContextBase;
import ch.qos.logback.core.Layout;
import ch.qos.logback.core.contention.MultiThreadedHarness;
import ch.qos.logback.core.contention.RunnableWithCounterAndDone;
import ch.qos.logback.core.layout.EchoLayout;
import ch.qos.logback.core.rolling.FixedWindowRollingPolicy;
import ch.qos.logback.core.rolling.RollingFileAppender;
import ch.qos.logback.core.rolling.RollingPolicy;
import ch.qos.logback.core.rolling.SizeBasedTriggeringPolicy;
import ch.qos.logback.core.rolling.TimeBasedRollingPolicy;
import ch.qos.logback.core.rolling.TriggeringPolicy;
import ch.qos.logback.core.status.StatusChecker;
import ch.qos.logback.core.testUtil.RandomUtil;
import ch.qos.logback.core.util.StatusPrinter;
import java.io.File;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiThreadedRollingTest {
    static final int NUM_THREADS = 10;
    static final int TOTAL_DURATION = 2000;
    RunnableWithCounterAndDone[] runnableArray;
    Layout<Object> layout;
    Context context = new ContextBase();
    int diff = RandomUtil.getPositiveInt();
    String outputDirStr = "target/test-output/multi-" + this.diff + "/";
    RollingFileAppender<Object> rfa = new RollingFileAppender();

    @Before
    public void setUp() throws Exception {
        this.layout = new EchoLayout();
        File outputDir = new File(this.outputDirStr);
        outputDir.mkdirs();
        this.rfa.setName("rolling");
        this.rfa.setLayout(this.layout);
        this.rfa.setContext(this.context);
        this.rfa.setFile(this.outputDirStr + "output.log");
    }

    @After
    public void tearDown() throws Exception {
        this.rfa.stop();
    }

    public void setUpTImeBasedTriggeringPolicy(RollingFileAppender<Object> rfa) {
        String datePattern = "yyyy-MM-dd'T'HH_mm_ss_SSS";
        TimeBasedRollingPolicy tbrp = new TimeBasedRollingPolicy();
        tbrp.setFileNamePattern(this.outputDirStr + "test-%d{" + datePattern + "}");
        tbrp.setContext(this.context);
        tbrp.setParent(rfa);
        tbrp.start();
        rfa.setRollingPolicy((RollingPolicy)tbrp);
        rfa.start();
    }

    public void setUpSizeBasedTriggeringPolicy(RollingFileAppender<Object> rfa) {
        SizeBasedTriggeringPolicy zbtp = new SizeBasedTriggeringPolicy();
        zbtp.setContext(this.context);
        zbtp.setMaxFileSize("100KB");
        zbtp.start();
        rfa.setTriggeringPolicy((TriggeringPolicy)zbtp);
        FixedWindowRollingPolicy fwrp = new FixedWindowRollingPolicy();
        fwrp.setContext(this.context);
        fwrp.setFileNamePattern(this.outputDirStr + "test-%i.log");
        fwrp.setMaxIndex(10);
        fwrp.setMinIndex(0);
        fwrp.setParent(rfa);
        fwrp.start();
        rfa.setRollingPolicy((RollingPolicy)fwrp);
        rfa.start();
    }

    RunnableWithCounterAndDone[] buildRunnableArray() {
        RunnableWithCounterAndDone[] runnableArray = new RunnableWithCounterAndDone[10];
        for (int i = 0; i < 10; ++i) {
            runnableArray[i] = new RFARunnable(i, this.rfa);
        }
        return runnableArray;
    }

    @Test
    public void multiThreadedTimedBased() throws InterruptedException {
        this.setUpTImeBasedTriggeringPolicy(this.rfa);
        this.executeHarness();
        this.printScriptForTimeBased();
    }

    @Test
    public void multiThreadedSizeBased() throws InterruptedException {
        this.setUpSizeBasedTriggeringPolicy(this.rfa);
        this.executeHarness();
        this.printScriptForSizeBased();
    }

    private void printScriptHeader(String type) {
        this.out("# ====================================================");
        this.out("# Adapt this scipt to check the exactness of the output ");
        this.out("# produced by " + type + " test");
        this.out("# ====================================================");
        this.out("# ");
        this.out("# cd to " + this.outputDirStr);
    }

    private void printCommonScriptCore() {
        this.out("");
        this.out("for t in $(seq 0 1 9)");
        this.out("do");
        this.out("  echo \"Testing results of thread $t\"");
        this.out("  grep \"$t \" aggregated | cut -d ' ' -f 2 > ${t}-sample");
        this.out("  for j in $(seq 1 1 ${end[$t]}); do echo $j; done > ${t}-witness");
        this.out("  diff -q -w ${t}-sample ${t}-witness;");
        this.out("  res=$?");
        this.out("  if [ $res != \"0\" ]; then");
        this.out("    echo \"FAILED for $t\"");
        this.out("    exit 1");
        this.out("  fi");
        this.out("done");
        this.out("");
        this.out("echo SUCCESS");
    }

    private void printScriptForTimeBased() {
        this.printScriptHeader("TimeBased");
        for (int i = 0; i < 10; ++i) {
            this.out("end[" + i + "]=" + this.runnableArray[i].getCounter());
        }
        this.out("");
        this.out("rm aggregated");
        this.out("cat test* output.log >> aggregated");
        this.printCommonScriptCore();
    }

    private void printScriptForSizeBased() {
        this.printScriptHeader("SizeBased");
        for (int i = 0; i < 10; ++i) {
            this.out("end[" + i + "]=" + this.runnableArray[i].getCounter());
        }
        this.out("");
        this.out("rm aggregated");
        this.out("Modify the integer set to include all test-* files");
        this.out("for i in 3 2 1 0; do cat test-$i.log >> aggregated; done");
        this.out("cat output.log >> aggregated");
        this.out("");
        this.printCommonScriptCore();
    }

    private void out(String msg) {
        System.out.println(msg);
    }

    private void executeHarness() throws InterruptedException {
        MultiThreadedHarness multiThreadedHarness = new MultiThreadedHarness(2000L);
        this.runnableArray = this.buildRunnableArray();
        multiThreadedHarness.execute(this.runnableArray);
        StatusChecker checker = new StatusChecker(this.context.getStatusManager());
        if (!checker.isErrorFree()) {
            Assert.fail((String)"errors reported");
            StatusPrinter.print((Context)this.context);
        }
    }

    long diff(long start) {
        return System.currentTimeMillis() - start;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class RFARunnable
    extends RunnableWithCounterAndDone {
        RollingFileAppender<Object> rfa;
        int id;

        RFARunnable(int id, RollingFileAppender<Object> rfa) {
            this.id = id;
            this.rfa = rfa;
        }

        @Override
        public void run() {
            while (!this.isDone()) {
                ++this.counter;
                this.rfa.doAppend((Object)(this.id + " " + this.counter));
            }
        }
    }
}

