/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.rolling;

import ch.qos.logback.core.Context;
import ch.qos.logback.core.Layout;
import ch.qos.logback.core.rolling.RollingFileAppender;
import ch.qos.logback.core.rolling.ScaffoldingForRollingTests;
import ch.qos.logback.core.rolling.SizeAndTimeBasedFNATP;
import ch.qos.logback.core.rolling.TimeBasedRollingPolicy;
import ch.qos.logback.core.util.StatusPrinter;
import java.util.Date;
import org.junit.Before;
import org.junit.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SizeAndTimeBasedFNATP_Test
extends ScaffoldingForRollingTests {
    SizeAndTimeBasedFNATP<Object> sizeAndTimeBasedFNATP;
    RollingFileAppender<Object> rfa1 = new RollingFileAppender();
    TimeBasedRollingPolicy<Object> tbrp1 = new TimeBasedRollingPolicy();
    RollingFileAppender<Object> rfa2 = new RollingFileAppender();
    TimeBasedRollingPolicy<Object> tbrp2 = new TimeBasedRollingPolicy();
    int fileSize = 0;
    int fileIndexCounter = 0;
    int sizeThreshold;

    @Override
    @Before
    public void setUp() {
        super.setUp();
    }

    void initRFA(RollingFileAppender<Object> rfa, String filename) {
        rfa.setContext(this.context);
        rfa.setLayout((Layout)this.layout);
        if (filename != null) {
            rfa.setFile(filename);
        }
    }

    void initTRBP(RollingFileAppender<Object> rfa, TimeBasedRollingPolicy<Object> tbrp, String filenamePattern, int sizeThreshold, long givenTime, long lastCheck) {
        this.sizeAndTimeBasedFNATP = new SizeAndTimeBasedFNATP();
        tbrp.setContext(this.context);
        this.sizeAndTimeBasedFNATP.setMaxFileSize("" + sizeThreshold);
        tbrp.setTimeBasedFileNamingAndTriggeringPolicy(this.sizeAndTimeBasedFNATP);
        tbrp.setFileNamePattern(filenamePattern);
        tbrp.setParent(rfa);
        tbrp.timeBasedTriggering.setCurrentTime(givenTime);
        rfa.setRollingPolicy(tbrp);
        tbrp.start();
        rfa.start();
    }

    @Test
    public void noCompression_FileSet_NoRestart_1() throws Exception {
        String testId = "test1";
        String file = this.randomOutputDir + "toto.log";
        this.initRFA(this.rfa1, file);
        this.sizeThreshold = 300;
        this.initTRBP(this.rfa1, this.tbrp1, this.randomOutputDir + testId + "-%d{" + "yyyy-MM-dd_HH_mm_ss" + "}-%i.txt", this.sizeThreshold, this.currentTime, 0L);
        this.addExpectedFileName(testId, this.getDateOfCurrentPeriodsStart(), this.fileIndexCounter, false);
        this.incCurrentTime(100L);
        this.tbrp1.timeBasedTriggering.setCurrentTime(this.currentTime);
        int runLength = 100;
        String prefix = "Hello -----------------";
        for (int i = 0; i < runLength; ++i) {
            String msg = prefix + i;
            this.rfa1.doAppend((Object)msg);
            this.addExpectedFileNamedIfItsTime(testId, msg, false);
            this.incCurrentTime(20L);
            this.tbrp1.timeBasedTriggering.setCurrentTime(this.currentTime);
        }
        this.massageExpectedFilesToCorresponToCurrentTarget(file);
        SizeAndTimeBasedFNATP_Test.existenceCheck(this.expectedFilenameList);
        SizeAndTimeBasedFNATP_Test.sortedContentCheck(this.randomOutputDir, runLength, prefix);
    }

    @Test
    public void noCompression_FileBlank_NoRestart_2() throws Exception {
        String testId = "test1";
        this.initRFA(this.rfa1, null);
        this.sizeThreshold = 300;
        this.initTRBP(this.rfa1, this.tbrp1, this.randomOutputDir + testId + "-%d{" + "yyyy-MM-dd_HH_mm_ss" + "}-%i.txt", this.sizeThreshold, this.currentTime, 0L);
        this.addExpectedFileName(testId, this.getDateOfCurrentPeriodsStart(), this.fileIndexCounter, false);
        this.incCurrentTime(100L);
        this.tbrp1.timeBasedTriggering.setCurrentTime(this.currentTime);
        int runLength = 100;
        String prefix = "Hello -----------------";
        for (int i = 0; i < runLength; ++i) {
            String msg = prefix + i;
            this.rfa1.doAppend((Object)msg);
            this.addExpectedFileNamedIfItsTime(testId, msg, false);
            this.incCurrentTime(20L);
            this.tbrp1.timeBasedTriggering.setCurrentTime(this.currentTime);
        }
        SizeAndTimeBasedFNATP_Test.existenceCheck(this.expectedFilenameList);
        SizeAndTimeBasedFNATP_Test.sortedContentCheck(this.randomOutputDir, runLength, prefix);
    }

    @Test
    public void noCompression_FileBlank_WithStopStart_3() throws Exception {
        String msg;
        int i;
        String testId = "test3";
        this.initRFA(this.rfa1, null);
        this.sizeThreshold = 300;
        this.initTRBP(this.rfa1, this.tbrp1, this.randomOutputDir + testId + "-%d{" + "yyyy-MM-dd_HH_mm_ss" + "}-%i.txt", this.sizeThreshold, this.currentTime, 0L);
        this.addExpectedFileName(testId, this.getDateOfCurrentPeriodsStart(), this.fileIndexCounter, false);
        this.incCurrentTime(100L);
        this.tbrp1.timeBasedTriggering.setCurrentTime(this.currentTime);
        int runLength = 100;
        String prefix = "Hello -----------------";
        for (i = 0; i < runLength; ++i) {
            msg = prefix + i;
            this.rfa1.doAppend((Object)msg);
            this.addExpectedFileNamedIfItsTime(testId, msg, false);
            this.incCurrentTime(20L);
            this.tbrp1.timeBasedTriggering.setCurrentTime(this.currentTime);
        }
        this.rfa1.stop();
        this.initRFA(this.rfa2, null);
        this.initTRBP(this.rfa2, this.tbrp2, this.randomOutputDir + testId + "-%d{" + "yyyy-MM-dd_HH_mm_ss" + "}-%i.txt", this.sizeThreshold, this.currentTime, 0L);
        runLength *= 2;
        while (i < runLength) {
            msg = prefix + i;
            this.addExpectedFileNamedIfItsTime(testId, msg, false);
            this.rfa2.doAppend((Object)msg);
            this.incCurrentTime(100L);
            this.tbrp2.timeBasedTriggering.setCurrentTime(this.currentTime);
            ++i;
        }
        StatusPrinter.print((Context)this.context);
        SizeAndTimeBasedFNATP_Test.existenceCheck(this.expectedFilenameList);
        SizeAndTimeBasedFNATP_Test.sortedContentCheck(this.randomOutputDir, runLength, prefix);
    }

    void massageExpectedFilesToCorresponToCurrentTarget(String file) {
        this.expectedFilenameList.remove(this.expectedFilenameList.size() - 1);
        this.expectedFilenameList.add(file);
    }

    void addExpectedFileNamedIfItsTime(String testId, String msg, boolean gzExtension) {
        this.fileSize += msg.getBytes().length;
        if (this.passThresholdTime(this.nextRolloverThreshold)) {
            this.fileIndexCounter = 0;
            this.fileSize = 0;
            this.addExpectedFileName(testId, this.getDateOfCurrentPeriodsStart(), this.fileIndexCounter, gzExtension);
            this.recomputeRolloverThreshold(this.currentTime);
            return;
        }
        if (this.fileIndexCounter < 1 && this.fileSize > this.sizeThreshold) {
            this.addExpectedFileName(testId, this.getDateOfCurrentPeriodsStart(), ++this.fileIndexCounter, gzExtension);
            this.fileSize = 0;
            return;
        }
    }

    void addExpectedFileName(String testId, Date date, int fileIndexCounter, boolean gzExtension) {
        String fn = this.randomOutputDir + testId + "-" + SDF.format(date) + "-" + fileIndexCounter + ".txt";
        if (gzExtension) {
            fn = fn + ".gz";
        }
        this.expectedFilenameList.add(fn);
    }
}

