/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.rolling;

import ch.qos.logback.core.Context;
import ch.qos.logback.core.ContextBase;
import ch.qos.logback.core.FileAppender;
import ch.qos.logback.core.Layout;
import ch.qos.logback.core.layout.DummyLayout;
import ch.qos.logback.core.layout.EchoLayout;
import ch.qos.logback.core.rolling.FixedWindowRollingPolicy;
import ch.qos.logback.core.rolling.RollingFileAppender;
import ch.qos.logback.core.rolling.RollingPolicy;
import ch.qos.logback.core.rolling.ScaffoldingForRollingTests;
import ch.qos.logback.core.rolling.SizeBasedTriggeringPolicy;
import ch.qos.logback.core.rolling.TriggeringPolicy;
import java.io.File;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class SizeBasedRollingTest
extends ScaffoldingForRollingTests {
    @Before
    public void setUp() {
        super.setUp();
        File target = new File("target/test-output/sizeBased-smoke.log");
        target.mkdirs();
        target.delete();
        target = new File("target/test-output/sbr-test3.log");
        target.mkdirs();
        target.delete();
    }

    @After
    public void tearDown() {
    }

    @Test
    public void activeFileNameNotSet() throws Exception {
        ContextBase context = new ContextBase();
        DummyLayout layout = new DummyLayout();
        RollingFileAppender rfa = new RollingFileAppender();
        rfa.setLayout(layout);
        rfa.setContext((Context)new ContextBase());
        FixedWindowRollingPolicy fwrp = new FixedWindowRollingPolicy();
        fwrp.setContext((Context)context);
        fwrp.setParent((FileAppender)rfa);
        SizeBasedTriggeringPolicy sbtp = new SizeBasedTriggeringPolicy();
        sbtp.setContext((Context)context);
        sbtp.setMaxFileSize("100");
        sbtp.start();
        fwrp.setFileNamePattern("target/test-output/sizeBased-test1.%i");
        try {
            fwrp.start();
            Assert.fail((String)"The absence of activeFileName option should have caused an exception.");
        }
        catch (IllegalStateException e) {
            return;
        }
    }

    @Test
    public void smoke() throws Exception {
        ContextBase context = new ContextBase();
        EchoLayout layout = new EchoLayout();
        RollingFileAppender rfa = new RollingFileAppender();
        rfa.setName("ROLLING");
        rfa.setLayout((Layout)layout);
        rfa.setContext((Context)context);
        rfa.setFile(this.randomOutputDir + "a-sizeBased-smoke.log");
        FixedWindowRollingPolicy swrp = new FixedWindowRollingPolicy();
        swrp.setContext((Context)context);
        SizeBasedTriggeringPolicy sbtp = new SizeBasedTriggeringPolicy();
        sbtp.setContext((Context)context);
        sbtp.setMaxFileSize("100");
        swrp.setMinIndex(0);
        swrp.setFileNamePattern(this.randomOutputDir + "sizeBased-smoke.%i");
        swrp.setParent((FileAppender)rfa);
        swrp.start();
        rfa.setRollingPolicy((RollingPolicy)swrp);
        rfa.setTriggeringPolicy((TriggeringPolicy)sbtp);
        rfa.start();
        int runLength = 45;
        String prefix = "hello";
        for (int i = 0; i < runLength; ++i) {
            Thread.sleep(10L);
            rfa.doAppend((Object)(prefix + i));
        }
        this.expectedFilenameList.add(this.randomOutputDir + "a-sizeBased-smoke.log");
        this.expectedFilenameList.add(this.randomOutputDir + "sizeBased-smoke.0");
        this.expectedFilenameList.add(this.randomOutputDir + "sizeBased-smoke.1");
        SizeBasedRollingTest.existenceCheck(this.expectedFilenameList);
        SizeBasedRollingTest.reverseSortedContentCheck(this.randomOutputDir, runLength, prefix);
    }

    @Test
    public void test3() throws Exception {
        ContextBase context = new ContextBase();
        EchoLayout layout = new EchoLayout();
        RollingFileAppender rfa = new RollingFileAppender();
        rfa.setLayout((Layout)layout);
        rfa.setContext((Context)context);
        rfa.setFile(this.randomOutputDir + "a-sbr-test3.log");
        FixedWindowRollingPolicy fwrp = new FixedWindowRollingPolicy();
        fwrp.setContext((Context)context);
        SizeBasedTriggeringPolicy sbtp = new SizeBasedTriggeringPolicy();
        sbtp.setContext((Context)context);
        sbtp.setMaxFileSize("100");
        fwrp.setMinIndex(0);
        fwrp.setFileNamePattern(this.randomOutputDir + "sbr-test3.%i.gz");
        fwrp.setParent((FileAppender)rfa);
        fwrp.start();
        rfa.setRollingPolicy((RollingPolicy)fwrp);
        rfa.setTriggeringPolicy((TriggeringPolicy)sbtp);
        rfa.start();
        int runLength = 40;
        String prefix = "hello";
        for (int i = 0; i < runLength; ++i) {
            Thread.sleep(10L);
            rfa.doAppend((Object)("hello" + i));
        }
        this.expectedFilenameList.add(this.randomOutputDir + "a-sbr-test3.log");
        this.expectedFilenameList.add(this.randomOutputDir + "sbr-test3.0.gz");
        this.expectedFilenameList.add(this.randomOutputDir + "sbr-test3.1.gz");
        SizeBasedRollingTest.existenceCheck(this.expectedFilenameList);
        SizeBasedRollingTest.reverseSortedContentCheck(this.randomOutputDir, runLength, prefix);
    }
}

