/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.joran.action;

import ch.qos.logback.core.Context;
import ch.qos.logback.core.ContextBase;
import ch.qos.logback.core.joran.TrivialConfigurator;
import ch.qos.logback.core.joran.action.Action;
import ch.qos.logback.core.joran.action.IncludeAction;
import ch.qos.logback.core.joran.action.NOPAction;
import ch.qos.logback.core.joran.action.ext.IncAction;
import ch.qos.logback.core.joran.spi.JoranException;
import ch.qos.logback.core.joran.spi.Pattern;
import ch.qos.logback.core.status.StatusChecker;
import ch.qos.logback.core.testUtil.Env;
import ch.qos.logback.core.testUtil.RandomUtil;
import ch.qos.logback.core.util.StatusPrinter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.UnknownHostException;
import java.util.HashMap;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.xml.sax.SAXParseException;

public class IncludeActionTest {
    static final String INCLUDE_KEY = "includeKey";
    static final String SUB_FILE_KEY = "subFileKey";
    static final String SECOND_FILE_KEY = "secondFileKey";
    Context context = new ContextBase();
    TrivialConfigurator tc;
    static final String INCLUSION_DIR_PREFIX = "src/test/input/joran/inclusion/";
    static final String TOP_BY_FILE = "src/test/input/joran/inclusion/topByFile.xml";
    static final String SUB_FILE = "src/test/input/joran/inclusion/subByFile.xml";
    static final String MULTI_INCLUDE_BY_FILE = "src/test/input/joran/inclusion/multiIncludeByFile.xml";
    static final String SECOND_FILE = "src/test/input/joran/inclusion/second.xml";
    static final String TOP_BY_URL = "src/test/input/joran/inclusion/topByUrl.xml";
    static final String INCLUDE_BY_RESOURCE = "src/test/input/joran/inclusion/topByResource.xml";
    static final String INCLUDED_FILE = "src/test/input/joran/inclusion/included.xml";
    static final String URL_TO_INCLUDE = "file:./src/test/input/joran/inclusion/included.xml";
    static final String INVALID = "src/test/input/joran/inclusion/invalid.xml";
    static final String INCLUDED_AS_RESOURCE = "asResource/joran/inclusion/includedAsResource.xml";
    int diff = RandomUtil.getPositiveInt();

    public IncludeActionTest() {
        HashMap<Pattern, Action> rulesMap = new HashMap<Pattern, Action>();
        rulesMap.put(new Pattern("x"), (Action)new NOPAction());
        rulesMap.put(new Pattern("x/inc"), new IncAction());
        rulesMap.put(new Pattern("x/include"), (Action)new IncludeAction());
        this.tc = new TrivialConfigurator(rulesMap);
        this.tc.setContext(this.context);
    }

    @Before
    public void setUp() throws Exception {
        IncAction.reset();
    }

    @After
    public void tearDown() throws Exception {
        this.context = null;
        System.clearProperty(INCLUDE_KEY);
        System.clearProperty(SECOND_FILE_KEY);
        System.clearProperty(SUB_FILE_KEY);
    }

    @Test
    public void basicFile() throws JoranException {
        System.setProperty(INCLUDE_KEY, INCLUDED_FILE);
        this.tc.doConfigure(TOP_BY_FILE);
        this.verifyConfig(2);
    }

    @Test
    public void basicResource() throws JoranException {
        System.setProperty(INCLUDE_KEY, INCLUDED_AS_RESOURCE);
        this.tc.doConfigure(INCLUDE_BY_RESOURCE);
        StatusPrinter.print((Context)this.context);
        this.verifyConfig(2);
    }

    @Test
    public void basicURL() throws JoranException {
        System.setProperty(INCLUDE_KEY, URL_TO_INCLUDE);
        this.tc.doConfigure(TOP_BY_URL);
        StatusPrinter.print((Context)this.context);
        this.verifyConfig(2);
    }

    @Test
    public void noFileFound() throws JoranException {
        System.setProperty(INCLUDE_KEY, "toto");
        this.tc.doConfigure(TOP_BY_FILE);
        Assert.assertEquals((long)2L, (long)this.context.getStatusManager().getLevel());
        StatusChecker sc = new StatusChecker(this.context.getStatusManager());
        Assert.assertTrue((boolean)sc.containsException(FileNotFoundException.class));
    }

    @Test
    public void withCorruptFile() throws JoranException, IOException {
        String tmpOut = this.copyToTemp(INVALID);
        System.setProperty(INCLUDE_KEY, tmpOut);
        this.tc.doConfigure(TOP_BY_FILE);
        Assert.assertEquals((long)2L, (long)this.context.getStatusManager().getLevel());
        StatusChecker sc = new StatusChecker(this.context.getStatusManager());
        Assert.assertTrue((boolean)sc.containsException(SAXParseException.class));
        File f = new File(tmpOut);
        Assert.assertTrue((boolean)f.exists());
        Assert.assertTrue((boolean)f.delete());
    }

    String copyToTemp(String in) throws IOException {
        int b;
        FileInputStream fis = new FileInputStream(in);
        String out = "target/test-output/out" + this.diff;
        FileOutputStream fos = new FileOutputStream(out);
        while ((b = fis.read()) != -1) {
            fos.write(b);
        }
        fis.close();
        fos.close();
        return out;
    }

    @Test
    public void malformedURL() throws JoranException {
        System.setProperty(INCLUDE_KEY, "htp://logback.qos.ch");
        this.tc.doConfigure(TOP_BY_URL);
        Assert.assertEquals((long)2L, (long)this.context.getStatusManager().getLevel());
        StatusChecker sc = new StatusChecker(this.context.getStatusManager());
        Assert.assertTrue((boolean)sc.containsException(MalformedURLException.class));
    }

    @Test
    public void unknownURL() throws JoranException {
        System.setProperty(INCLUDE_KEY, "http://logback2345.qos.ch");
        this.tc.doConfigure(TOP_BY_URL);
        Assert.assertEquals((long)2L, (long)this.context.getStatusManager().getLevel());
        StatusChecker sc = new StatusChecker(this.context.getStatusManager());
        if (!Env.isMac()) {
            Assert.assertTrue((boolean)sc.containsException(UnknownHostException.class));
        }
    }

    @Test
    public void nestedInclude() throws JoranException {
        System.setProperty(SUB_FILE_KEY, INCLUDED_FILE);
        System.setProperty(INCLUDE_KEY, SECOND_FILE);
        this.tc.doConfigure(TOP_BY_FILE);
        StatusPrinter.print((Context)this.context);
        this.verifyConfig(1);
    }

    @Test
    public void multiInclude() throws JoranException {
        System.setProperty(INCLUDE_KEY, INCLUDED_FILE);
        System.setProperty(SECOND_FILE_KEY, SECOND_FILE);
        this.tc.doConfigure(MULTI_INCLUDE_BY_FILE);
        this.verifyConfig(3);
    }

    @Test
    public void saxParseException() throws JoranException {
        System.setProperty(INCLUDE_KEY, INCLUDED_FILE);
        System.setProperty(SECOND_FILE_KEY, SECOND_FILE);
        this.tc.doConfigure(MULTI_INCLUDE_BY_FILE);
        this.verifyConfig(3);
    }

    @Test
    public void errorInDoBegin() {
    }

    void verifyConfig(int expected) {
        Assert.assertEquals((long)expected, (long)IncAction.beginCount);
        Assert.assertEquals((long)expected, (long)IncAction.endCount);
    }
}

