/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.joran.event;

import ch.qos.logback.core.Context;
import ch.qos.logback.core.ContextBase;
import ch.qos.logback.core.joran.event.BodyEvent;
import ch.qos.logback.core.joran.event.SaxEvent;
import ch.qos.logback.core.joran.event.SaxEventRecorder;
import ch.qos.logback.core.joran.event.StartEvent;
import ch.qos.logback.core.status.StatusManager;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.List;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.junit.Assert;
import org.junit.Test;
import org.xml.sax.Attributes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SaxEventRecorderTest {
    Context context = new ContextBase();

    SAXParser createParser() throws Exception {
        SAXParserFactory spf = SAXParserFactory.newInstance();
        return spf.newSAXParser();
    }

    public List<SaxEvent> doTest(String filename) throws Exception {
        SaxEventRecorder recorder = new SaxEventRecorder();
        recorder.setContext(this.context);
        FileInputStream fis = new FileInputStream("src/test/input/joran/" + filename);
        recorder.recordEvents((InputStream)fis);
        return recorder.getSaxEventList();
    }

    public void dump(List<SaxEvent> seList) {
        for (SaxEvent se : seList) {
            System.out.println(se);
        }
    }

    @Test
    public void test1() throws Exception {
        List<SaxEvent> seList = this.doTest("event1.xml");
        StatusManager sm = this.context.getStatusManager();
        Assert.assertTrue((sm.getLevel() == 0 ? 1 : 0) != 0);
        Assert.assertEquals((long)11L, (long)seList.size());
    }

    @Test
    public void test2() throws Exception {
        List<SaxEvent> seList = this.doTest("ampEvent.xml");
        StatusManager sm = this.context.getStatusManager();
        Assert.assertTrue((sm.getLevel() == 0 ? 1 : 0) != 0);
        Assert.assertEquals((long)3L, (long)seList.size());
        BodyEvent be = (BodyEvent)seList.get(1);
        Assert.assertEquals((Object)"xxx & yyy", (Object)be.getText());
    }

    @Test
    public void test3() throws Exception {
        List<SaxEvent> seList = this.doTest("inc.xml");
        StatusManager sm = this.context.getStatusManager();
        Assert.assertTrue((sm.getLevel() == 0 ? 1 : 0) != 0);
        Assert.assertEquals((long)4L, (long)seList.size());
        StartEvent se = (StartEvent)seList.get(1);
        Attributes attr = se.getAttributes();
        Assert.assertNotNull((Object)attr);
        Assert.assertEquals((Object)"1", (Object)attr.getValue("increment"));
    }

    @Test
    public void bodyWithSpacesAndQuotes() throws Exception {
        List<SaxEvent> seList = this.doTest("spacesAndQuotes.xml");
        Assert.assertEquals((long)3L, (long)seList.size());
        BodyEvent be = (BodyEvent)seList.get(1);
        Assert.assertEquals((Object)"[x][x] \"xyz\"%n", (Object)be.getText());
    }
}

