/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.rolling;

import ch.qos.logback.core.Context;
import ch.qos.logback.core.ContextBase;
import ch.qos.logback.core.FileAppender;
import ch.qos.logback.core.encoder.EchoEncoder;
import ch.qos.logback.core.encoder.Encoder;
import ch.qos.logback.core.rolling.DelayerUtil;
import ch.qos.logback.core.rolling.RollingFileAppender;
import ch.qos.logback.core.rolling.RollingPolicy;
import ch.qos.logback.core.rolling.TimeBasedRollingPolicy;
import ch.qos.logback.core.util.Compare;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class RenamingTest {
    Encoder<Object> encoder;
    Context context = new ContextBase();

    @Before
    public void setUp() throws Exception {
        this.encoder = new EchoEncoder();
        File target = new File("target/test-output/test.log");
        target.mkdirs();
        target.delete();
    }

    @Test
    public void testRename() throws Exception {
        RollingFileAppender rfa = new RollingFileAppender();
        rfa.setEncoder(this.encoder);
        rfa.setContext(this.context);
        String datePattern = "yyyy-MM-dd_HH_mm_ss";
        SimpleDateFormat sdf = new SimpleDateFormat(datePattern);
        String[] filenames = new String[2];
        TimeBasedRollingPolicy tbrp = new TimeBasedRollingPolicy();
        tbrp.setFileNamePattern("target/test-output/test-%d{" + datePattern + "}");
        tbrp.setContext(this.context);
        tbrp.setParent((FileAppender)rfa);
        tbrp.start();
        rfa.setRollingPolicy((RollingPolicy)tbrp);
        rfa.start();
        Calendar cal0 = Calendar.getInstance();
        rfa.doAppend((Object)"Hello 0");
        DelayerUtil.delayUntilNextSecond(50);
        Calendar cal1 = Calendar.getInstance();
        rfa.doAppend((Object)"Hello 1");
        filenames[0] = "target/test-output/test-" + sdf.format(cal0.getTime());
        filenames[1] = "target/test-output/test-" + sdf.format(cal1.getTime());
        for (int i = 0; i < filenames.length; ++i) {
            Assert.assertTrue((boolean)Compare.compare(filenames[i], "src/test/witness/rolling/renaming." + i));
        }
    }
}

