/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.rolling;

import ch.qos.logback.core.encoder.Encoder;
import ch.qos.logback.core.rolling.DefaultTimeBasedFileNamingAndTriggeringPolicy;
import ch.qos.logback.core.rolling.RollingFileAppender;
import ch.qos.logback.core.rolling.ScaffoldingForRollingTests;
import ch.qos.logback.core.rolling.TimeBasedRollingPolicy;
import ch.qos.logback.core.testUtil.RandomUtil;
import ch.qos.logback.core.util.Compare;
import java.io.File;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TimeBasedRollingTest
extends ScaffoldingForRollingTests {
    RollingFileAppender<Object> rfa1 = new RollingFileAppender();
    TimeBasedRollingPolicy<Object> tbrp1 = new TimeBasedRollingPolicy();
    RollingFileAppender<Object> rfa2 = new RollingFileAppender();
    TimeBasedRollingPolicy<Object> tbrp2 = new TimeBasedRollingPolicy();

    @Override
    @Before
    public void setUp() {
        super.setUp();
    }

    @After
    public void tearDown() {
    }

    void initRFA(RollingFileAppender<Object> rfa, String filename) {
        rfa.setContext(this.context);
        rfa.setEncoder((Encoder)this.encoder);
        if (filename != null) {
            rfa.setFile(filename);
        }
    }

    void initTRBP(RollingFileAppender<Object> rfa, TimeBasedRollingPolicy<Object> tbrp, String filenamePattern, long givenTime) {
        tbrp.setContext(this.context);
        tbrp.setFileNamePattern(filenamePattern);
        tbrp.setParent(rfa);
        tbrp.timeBasedTriggering = new DefaultTimeBasedFileNamingAndTriggeringPolicy();
        tbrp.timeBasedTriggering.setCurrentTime(givenTime);
        rfa.setRollingPolicy(tbrp);
        tbrp.start();
        rfa.start();
    }

    @Test
    public void noCompression_FileBlank_NoRestart_1() throws Exception {
        int i;
        String testId = "test1";
        this.initRFA(this.rfa1, null);
        this.initTRBP(this.rfa1, this.tbrp1, this.randomOutputDir + testId + "-%d{" + "yyyy-MM-dd_HH_mm_ss" + "}", this.currentTime);
        this.addExpectedFileName_ByDate(this.randomOutputDir, testId, this.getDateOfCurrentPeriodsStart(), false);
        this.incCurrentTime(1100L);
        this.tbrp1.timeBasedTriggering.setCurrentTime(this.currentTime);
        for (i = 0; i < 3; ++i) {
            this.rfa1.doAppend((Object)("Hello---" + i));
            this.addExpectedFileNamedIfItsTime_ByDate(this.randomOutputDir, testId, false);
            this.incCurrentTime(500L);
            this.tbrp1.timeBasedTriggering.setCurrentTime(this.currentTime);
        }
        i = 0;
        for (String fn : this.expectedFilenameList) {
            Assert.assertTrue((boolean)Compare.compare(fn, "src/test/witness/rolling/tbr-" + testId + "." + i++));
        }
    }

    @Test
    public void withCompression_FileBlank_NoRestart_2() throws Exception {
        int i;
        String testId = "test2";
        this.initRFA(this.rfa1, null);
        this.initTRBP(this.rfa1, this.tbrp1, this.randomOutputDir + testId + "-%d{" + "yyyy-MM-dd_HH_mm_ss" + "}.gz", this.currentTime);
        this.addExpectedFileName_ByDate(this.randomOutputDir, testId, this.getDateOfCurrentPeriodsStart(), true);
        this.incCurrentTime(1100L);
        this.tbrp1.timeBasedTriggering.setCurrentTime(this.currentTime);
        for (i = 0; i < 3; ++i) {
            this.addExpectedFileNamedIfItsTime_ByDate(this.randomOutputDir, testId, i != 2);
            this.rfa1.doAppend((Object)("Hello---" + i));
            this.incCurrentTime(500L);
            this.tbrp1.timeBasedTriggering.setCurrentTime(this.currentTime);
            TimeBasedRollingTest.waitForCompression(this.tbrp1);
        }
        i = 0;
        for (String fn : this.expectedFilenameList) {
            Assert.assertTrue((boolean)Compare.compare(fn, "src/test/witness/rolling/tbr-" + testId + "." + i + this.addGZIfNotLast(i)));
            ++i;
        }
    }

    @Test
    public void noCompression_FileBlank_StopRestart_3() throws Exception {
        int i;
        String testId = "test3";
        this.initRFA(this.rfa1, null);
        this.initTRBP(this.rfa1, this.tbrp1, this.randomOutputDir + testId + "-%d{" + "yyyy-MM-dd_HH_mm_ss" + "}", this.currentTime);
        this.addExpectedFileName_ByDate(this.randomOutputDir, testId, this.getDateOfCurrentPeriodsStart(), false);
        this.incCurrentTime(1100L);
        this.tbrp1.timeBasedTriggering.setCurrentTime(this.currentTime);
        for (i = 0; i <= 2; ++i) {
            this.rfa1.doAppend((Object)("Hello---" + i));
            this.addExpectedFileNamedIfItsTime_ByDate(this.randomOutputDir, testId, false);
            this.incCurrentTime(500L);
            this.tbrp1.timeBasedTriggering.setCurrentTime(this.currentTime);
        }
        this.rfa1.stop();
        this.initRFA(this.rfa2, null);
        this.initTRBP(this.rfa2, this.tbrp2, this.randomOutputDir + testId + "-%d{" + "yyyy-MM-dd_HH_mm_ss" + "}", this.tbrp1.timeBasedTriggering.getCurrentTime());
        for (i = 0; i <= 2; ++i) {
            this.addExpectedFileNamedIfItsTime_ByDate(this.randomOutputDir, testId, false);
            this.rfa2.doAppend((Object)("World---" + i));
            this.incCurrentTime(100L);
            this.tbrp2.timeBasedTriggering.setCurrentTime(this.currentTime);
        }
        i = 0;
        for (String fn : this.expectedFilenameList) {
            Assert.assertTrue((boolean)Compare.compare(fn, "src/test/witness/rolling/tbr-" + testId + "." + i++));
        }
    }

    @Test
    public void noCompression_FileSet_StopRestart_4() throws Exception {
        int i;
        String testId = "test4";
        this.initRFA(this.rfa1, this.testId2FileName(testId));
        this.initTRBP(this.rfa1, this.tbrp1, this.randomOutputDir + testId + "-%d{" + "yyyy-MM-dd_HH_mm_ss" + "}", this.currentTime);
        this.addExpectedFileName_ByDate(this.randomOutputDir, testId, this.getDateOfCurrentPeriodsStart(), false);
        this.incCurrentTime(1100L);
        this.tbrp1.timeBasedTriggering.setCurrentTime(this.currentTime);
        for (int i2 = 0; i2 <= 2; ++i2) {
            this.rfa1.doAppend((Object)("Hello---" + i2));
            this.addExpectedFileNamedIfItsTime_ByDate(this.randomOutputDir, testId, false);
            this.incCurrentTime(500L);
            this.tbrp1.timeBasedTriggering.setCurrentTime(this.currentTime);
        }
        this.rfa1.stop();
        File activeFile = new File(this.rfa1.getFile());
        activeFile.setLastModified(this.currentTime);
        this.initRFA(this.rfa2, this.testId2FileName(testId));
        this.initTRBP(this.rfa2, this.tbrp2, this.randomOutputDir + testId + "-%d{" + "yyyy-MM-dd_HH_mm_ss" + "}", this.currentTime);
        for (i = 0; i <= 2; ++i) {
            this.rfa2.doAppend((Object)("World---" + i));
            this.addExpectedFileNamedIfItsTime_ByDate(this.randomOutputDir, testId, false);
            this.incCurrentTime(100L);
            this.tbrp2.timeBasedTriggering.setCurrentTime(this.currentTime);
        }
        this.massageExpectedFilesToCorresponToCurrentTarget("test4.log");
        i = 0;
        for (String fn : this.expectedFilenameList) {
            Assert.assertTrue((boolean)Compare.compare(fn, "src/test/witness/rolling/tbr-" + testId + "." + i++));
        }
    }

    @Test
    public void noCompression_FileSet_StopRestart_WithLongWait_4B() throws Exception {
        int i;
        String testId = "test4B";
        this.initRFA(this.rfa1, this.testId2FileName(testId));
        this.initTRBP(this.rfa1, this.tbrp1, this.randomOutputDir + testId + "-%d{" + "yyyy-MM-dd_HH_mm_ss" + "}", this.currentTime);
        this.addExpectedFileName_ByDate(this.randomOutputDir, testId, this.getDateOfCurrentPeriodsStart(), false);
        this.incCurrentTime(1100L);
        this.tbrp1.timeBasedTriggering.setCurrentTime(this.currentTime);
        for (int i2 = 0; i2 <= 2; ++i2) {
            this.rfa1.doAppend((Object)("Hello---" + i2));
            this.addExpectedFileNamedIfItsTime_ByDate(this.randomOutputDir, testId, false);
            this.incCurrentTime(500L);
            this.tbrp1.timeBasedTriggering.setCurrentTime(this.currentTime);
        }
        this.rfa1.stop();
        File activeFile = new File(this.rfa1.getFile());
        activeFile.setLastModified(this.currentTime);
        this.incCurrentTime(2000L);
        this.initRFA(this.rfa2, this.randomOutputDir + "test4B.log");
        this.initTRBP(this.rfa2, this.tbrp2, this.randomOutputDir + testId + "-%d{" + "yyyy-MM-dd_HH_mm_ss" + "}", this.currentTime);
        for (i = 0; i <= 2; ++i) {
            this.rfa2.doAppend((Object)("World---" + i));
            this.addExpectedFileNamedIfItsTime_ByDate(this.randomOutputDir, testId, false);
            this.incCurrentTime(100L);
            this.tbrp2.timeBasedTriggering.setCurrentTime(this.currentTime);
        }
        this.massageExpectedFilesToCorresponToCurrentTarget("test4B.log");
        i = 0;
        for (String fn : this.expectedFilenameList) {
            Assert.assertTrue((boolean)Compare.compare(fn, "src/test/witness/rolling/tbr-test4B." + i++));
        }
    }

    @Test
    public void noCompression_FileSet_NoRestart_5() throws Exception {
        int i;
        String testId = "test5";
        this.initRFA(this.rfa1, this.testId2FileName(testId));
        this.initTRBP(this.rfa1, this.tbrp1, this.randomOutputDir + testId + "-%d{" + "yyyy-MM-dd_HH_mm_ss" + "}", this.currentTime);
        this.addExpectedFileName_ByDate(this.randomOutputDir, testId, this.getDateOfCurrentPeriodsStart(), false);
        this.incCurrentTime(1100L);
        this.tbrp1.timeBasedTriggering.setCurrentTime(this.currentTime);
        for (i = 0; i < 3; ++i) {
            this.rfa1.doAppend((Object)("Hello---" + i));
            this.addExpectedFileNamedIfItsTime_ByDate(this.randomOutputDir, testId, false);
            this.incCurrentTime(500L);
            this.tbrp1.timeBasedTriggering.setCurrentTime(this.currentTime);
        }
        this.massageExpectedFilesToCorresponToCurrentTarget("test5.log");
        i = 0;
        for (String fn : this.expectedFilenameList) {
            Assert.assertTrue((boolean)Compare.compare(fn, "src/test/witness/rolling/tbr-test5." + i++));
        }
    }

    @Test
    public void withCompression_FileSet_NoRestart_6() throws Exception {
        int i;
        String testId = "test6";
        this.initRFA(this.rfa1, this.testId2FileName(testId));
        this.initTRBP(this.rfa1, this.tbrp1, this.randomOutputDir + testId + "-%d{" + "yyyy-MM-dd_HH_mm_ss" + "}.gz", this.currentTime);
        this.addExpectedFileName_ByDate(this.randomOutputDir, testId, this.getDateOfCurrentPeriodsStart(), true);
        this.incCurrentTime(1100L);
        this.tbrp1.timeBasedTriggering.setCurrentTime(this.currentTime);
        for (i = 0; i < 3; ++i) {
            this.rfa1.doAppend((Object)("Hello---" + i));
            this.addExpectedFileNamedIfItsTime_ByDate(this.randomOutputDir, testId, true);
            this.incCurrentTime(500L);
            this.tbrp1.timeBasedTriggering.setCurrentTime(this.currentTime);
            TimeBasedRollingTest.waitForCompression(this.tbrp1);
        }
        this.massageExpectedFilesToCorresponToCurrentTarget("test6.log");
        i = 0;
        for (String fn : this.expectedFilenameList) {
            Assert.assertTrue((boolean)Compare.compare(fn, "src/test/witness/rolling/tbr-" + testId + "." + i + this.addGZIfNotLast(i)));
            ++i;
        }
    }

    @Test
    public void withMissingTargetDir() throws Exception {
        int i;
        String testId = "missingTargetDir";
        this.initRFA(this.rfa1, this.testId2FileName(testId));
        int secondDiff = RandomUtil.getPositiveInt();
        String randomTargetDir = "target/test-output/" + secondDiff + '/';
        System.out.println("randomOutputDir" + this.randomOutputDir);
        System.out.println("randomTargetDir" + randomTargetDir);
        this.initTRBP(this.rfa1, this.tbrp1, randomTargetDir + testId + "-%d{" + "yyyy-MM-dd_HH_mm_ss" + "}", this.currentTime);
        this.addExpectedFileName_ByDate(randomTargetDir, testId, this.getDateOfCurrentPeriodsStart(), false);
        this.incCurrentTime(1100L);
        this.tbrp1.timeBasedTriggering.setCurrentTime(this.currentTime);
        for (i = 0; i < 3; ++i) {
            this.rfa1.doAppend((Object)("Hello---" + i));
            this.addExpectedFileNamedIfItsTime_ByDate(randomTargetDir, testId, false);
            this.incCurrentTime(500L);
            this.tbrp1.timeBasedTriggering.setCurrentTime(this.currentTime);
        }
        this.massageExpectedFilesToCorresponToCurrentTarget("missingTargetDir.log");
        i = 0;
        for (String fn : this.expectedFilenameList) {
            System.out.println("expectedFile=" + fn);
            Assert.assertTrue((boolean)Compare.compare(fn, "src/test/witness/rolling/tbr-test5." + i++));
        }
    }

    void massageExpectedFilesToCorresponToCurrentTarget(String file) {
        this.expectedFilenameList.remove(this.expectedFilenameList.size() - 1);
        this.addExpectedFileName_ByFile(file);
    }

    void addExpectedFileName_ByFile(String filenameSuffix) {
        String fn = this.randomOutputDir + filenameSuffix;
        this.expectedFilenameList.add(fn);
    }
}

