/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.joran.conditional;

import ch.qos.logback.core.Context;
import ch.qos.logback.core.ContextBase;
import ch.qos.logback.core.joran.TrivialConfigurator;
import ch.qos.logback.core.joran.action.Action;
import ch.qos.logback.core.joran.action.NOPAction;
import ch.qos.logback.core.joran.action.ext.StackAction;
import ch.qos.logback.core.joran.conditional.ElseAction;
import ch.qos.logback.core.joran.conditional.IfAction;
import ch.qos.logback.core.joran.conditional.ThenAction;
import ch.qos.logback.core.joran.spi.JoranException;
import ch.qos.logback.core.joran.spi.Pattern;
import ch.qos.logback.core.status.StatusChecker;
import ch.qos.logback.core.testUtil.RandomUtil;
import ch.qos.logback.core.util.StatusPrinter;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Stack;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class IfThenElseTest {
    Context context = new ContextBase();
    TrivialConfigurator tc;
    int diff = RandomUtil.getPositiveInt();
    static final String CONDITIONAL_DIR_PREFIX = "src/test/input/joran/conditional/";

    @Before
    public void setUp() throws Exception {
        HashMap<Pattern, Action> rulesMap = new HashMap<Pattern, Action>();
        rulesMap.put(new Pattern("x"), (Action)new NOPAction());
        rulesMap.put(new Pattern("x/stack"), new StackAction());
        rulesMap.put(new Pattern("*/if"), (Action)new IfAction());
        rulesMap.put(new Pattern("*/if/then"), (Action)new ThenAction());
        rulesMap.put(new Pattern("*/if/then/*"), (Action)new NOPAction());
        rulesMap.put(new Pattern("*/if/else"), (Action)new ElseAction());
        rulesMap.put(new Pattern("*/if/else/*"), (Action)new NOPAction());
        this.tc = new TrivialConfigurator(rulesMap);
        this.tc.setContext(this.context);
    }

    @After
    public void tearDown() throws Exception {
        StatusPrinter.printIfErrorsOccured((Context)this.context);
        StackAction.reset();
    }

    @Test
    public void if0_Then() throws JoranException {
        this.context.putProperty("Ki1", "Val1");
        this.tc.doConfigure("src/test/input/joran/conditional/if0.xml");
        this.verifyConfig(new String[]{"BEGIN", "a", "END"});
    }

    @Test
    public void if0_Else() throws JoranException {
        this.tc.doConfigure("src/test/input/joran/conditional/if0.xml");
        this.verifyConfig(new String[]{"BEGIN", "b", "END"});
    }

    @Test
    public void ifWithoutElse_True() throws JoranException {
        this.context.putProperty("Ki1", "Val1");
        this.tc.doConfigure("src/test/input/joran/conditional/ifWithoutElse.xml");
        this.verifyConfig(new String[]{"BEGIN", "a", "END"});
    }

    @Test
    public void ifWithoutElse_False() throws JoranException {
        this.tc.doConfigure("src/test/input/joran/conditional/ifWithoutElse.xml");
        this.verifyConfig(new String[]{"BEGIN", "END"});
        StatusChecker checker = new StatusChecker(this.context);
        Assert.assertTrue((boolean)checker.isErrorFree());
    }

    @Test
    public void nestedIf() throws JoranException {
        this.tc.doConfigure("src/test/input/joran/conditional/nestedIf.xml");
        StatusPrinter.printIfErrorsOccured((Context)this.context);
        this.verifyConfig(new String[]{"BEGIN", "a", "c", "END"});
    }

    void verifyConfig(String[] expected) {
        Stack<String> witness = new Stack<String>();
        witness.addAll(Arrays.asList(expected));
        Assert.assertEquals(witness, StackAction.stack);
    }
}

