/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.joran.spi;

import ch.qos.logback.core.joran.spi.Pattern;
import org.junit.Assert;
import org.junit.Test;

public class PatternTest {
    @Test
    public void test1() {
        Pattern p = new Pattern("a");
        Assert.assertEquals((long)1L, (long)p.size());
        Assert.assertEquals((Object)"a", (Object)p.peekLast());
        Assert.assertEquals((Object)"a", (Object)p.get(0));
    }

    @Test
    public void testSuffix() {
        Pattern p = new Pattern("a/");
        Assert.assertEquals((long)1L, (long)p.size());
        Assert.assertEquals((Object)"a", (Object)p.peekLast());
        Assert.assertEquals((Object)"a", (Object)p.get(0));
    }

    @Test
    public void test2() {
        Pattern p = new Pattern("a/b");
        Assert.assertEquals((long)2L, (long)p.size());
        Assert.assertEquals((Object)"b", (Object)p.peekLast());
        Assert.assertEquals((Object)"a", (Object)p.get(0));
        Assert.assertEquals((Object)"b", (Object)p.get(1));
    }

    @Test
    public void test3() {
        Pattern p = new Pattern("a123/b1234/cvvsdf");
        Assert.assertEquals((long)3L, (long)p.size());
        Assert.assertEquals((Object)"a123", (Object)p.get(0));
        Assert.assertEquals((Object)"b1234", (Object)p.get(1));
        Assert.assertEquals((Object)"cvvsdf", (Object)p.get(2));
    }

    @Test
    public void test4() {
        Pattern p = new Pattern("/a123/b1234/cvvsdf");
        Assert.assertEquals((long)3L, (long)p.size());
        Assert.assertEquals((Object)"a123", (Object)p.get(0));
        Assert.assertEquals((Object)"b1234", (Object)p.get(1));
        Assert.assertEquals((Object)"cvvsdf", (Object)p.get(2));
    }

    @Test
    public void test5() {
        Pattern p = new Pattern("//a");
        Assert.assertEquals((long)1L, (long)p.size());
        Assert.assertEquals((Object)"a", (Object)p.get(0));
    }

    @Test
    public void test6() {
        Pattern p = new Pattern("//a//b");
        Assert.assertEquals((long)2L, (long)p.size());
        Assert.assertEquals((Object)"a", (Object)p.get(0));
        Assert.assertEquals((Object)"b", (Object)p.get(1));
    }

    @Test
    public void testTailMatch() {
        Pattern p = new Pattern("/a/b");
        Pattern rulePattern = new Pattern("*");
        Assert.assertEquals((long)0L, (long)p.getTailMatchLength(rulePattern));
        p = new Pattern("/a");
        rulePattern = new Pattern("*/a");
        Assert.assertEquals((long)1L, (long)p.getTailMatchLength(rulePattern));
        p = new Pattern("/A");
        rulePattern = new Pattern("*/a");
        Assert.assertEquals((long)1L, (long)p.getTailMatchLength(rulePattern));
        p = new Pattern("/a");
        rulePattern = new Pattern("*/A");
        Assert.assertEquals((long)1L, (long)p.getTailMatchLength(rulePattern));
        p = new Pattern("/a/b");
        rulePattern = new Pattern("*/b");
        Assert.assertEquals((long)1L, (long)p.getTailMatchLength(rulePattern));
        p = new Pattern("/a/B");
        rulePattern = new Pattern("*/b");
        Assert.assertEquals((long)1L, (long)p.getTailMatchLength(rulePattern));
        p = new Pattern("/a/b/c");
        rulePattern = new Pattern("*/b/c");
        Assert.assertEquals((long)2L, (long)p.getTailMatchLength(rulePattern));
    }

    @Test
    public void testPrefixMatch() {
        Pattern p = new Pattern("/a/b");
        Pattern rulePattern = new Pattern("/x/*");
        Assert.assertEquals((long)0L, (long)p.getPrefixMatchLength(rulePattern));
        p = new Pattern("/a");
        rulePattern = new Pattern("/x/*");
        Assert.assertEquals((long)0L, (long)p.getPrefixMatchLength(rulePattern));
        p = new Pattern("/a/b");
        rulePattern = new Pattern("/a/*");
        Assert.assertEquals((long)1L, (long)p.getPrefixMatchLength(rulePattern));
        p = new Pattern("/a/b");
        rulePattern = new Pattern("/A/*");
        Assert.assertEquals((long)1L, (long)p.getPrefixMatchLength(rulePattern));
        p = new Pattern("/A/b");
        rulePattern = new Pattern("/a/*");
        Assert.assertEquals((long)1L, (long)p.getPrefixMatchLength(rulePattern));
        p = new Pattern("/a/b");
        rulePattern = new Pattern("/a/b/*");
        Assert.assertEquals((long)2L, (long)p.getPrefixMatchLength(rulePattern));
        p = new Pattern("/a/b");
        rulePattern = new Pattern("/*");
        Assert.assertEquals((long)0L, (long)p.getPrefixMatchLength(rulePattern));
    }
}

