/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.recovery;

import ch.qos.logback.core.recovery.RecoveryCoordinator;
import org.junit.Assert;
import org.junit.Test;

public class RecoveryCoordinatorTest {
    RecoveryCoordinator rc = new RecoveryCoordinator();
    long now = System.currentTimeMillis();

    @Test
    public void actualTime() throws InterruptedException {
        Assert.assertTrue((boolean)this.rc.isTooSoon());
        Thread.sleep(120L);
        Assert.assertFalse((boolean)this.rc.isTooSoon());
    }

    @Test
    public void smoke() {
        Assert.assertTrue((boolean)this.rc.isTooSoon());
        this.rc.setCurrentTime(this.now + 100L + 1L);
        Assert.assertFalse((boolean)this.rc.isTooSoon());
    }

    @Test
    public void longTermFailure() {
        long offset = 100L;
        int tooSoonCount = 0;
        for (int i = 0; i < 16; ++i) {
            this.rc.setCurrentTime(this.now + offset);
            if (this.rc.isTooSoon()) {
                ++tooSoonCount;
            }
            offset *= 2L;
        }
        Assert.assertEquals((long)7L, (long)tooSoonCount);
    }
}

