/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.rolling;

import ch.qos.logback.core.Context;
import ch.qos.logback.core.ContextBase;
import ch.qos.logback.core.FileAppender;
import ch.qos.logback.core.encoder.EchoEncoder;
import ch.qos.logback.core.encoder.Encoder;
import ch.qos.logback.core.rolling.RollingFileAppender;
import ch.qos.logback.core.rolling.RollingPolicy;
import ch.qos.logback.core.rolling.RolloverFailure;
import ch.qos.logback.core.rolling.TimeBasedFileNamingAndTriggeringPolicy;
import ch.qos.logback.core.rolling.TimeBasedRollingPolicy;
import ch.qos.logback.core.rolling.helper.RenameUtil;
import ch.qos.logback.core.status.StatusChecker;
import ch.qos.logback.core.testUtil.RandomUtil;
import ch.qos.logback.core.util.Compare;
import ch.qos.logback.core.util.StatusPrinter;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class RenameUtilTest {
    Encoder<Object> encoder;
    Context context = new ContextBase();
    StatusChecker statusChecker = new StatusChecker(this.context);
    long currentTime = System.currentTimeMillis();
    int diff = RandomUtil.getPositiveInt();
    protected String randomOutputDirAsStr = "target/test-output/" + this.diff + "/";
    protected File randomOutputDir = new File(this.randomOutputDirAsStr);

    @Before
    public void setUp() throws Exception {
        this.encoder = new EchoEncoder();
        this.randomOutputDir.mkdirs();
    }

    @Test
    public void rename() throws Exception {
        RollingFileAppender rfa = new RollingFileAppender();
        rfa.setEncoder(this.encoder);
        rfa.setContext(this.context);
        String datePattern = "yyyy-MM-dd_HH_mm_ss";
        SimpleDateFormat sdf = new SimpleDateFormat(datePattern);
        String[] filenames = new String[2];
        TimeBasedRollingPolicy tbrp = new TimeBasedRollingPolicy();
        tbrp.setFileNamePattern(this.randomOutputDirAsStr + "test-%d{" + datePattern + "}");
        tbrp.setContext(this.context);
        tbrp.setParent((FileAppender)rfa);
        tbrp.start();
        TimeBasedFileNamingAndTriggeringPolicy tbnatp = tbrp.getTimeBasedFileNamingAndTriggeringPolicy();
        tbnatp.setCurrentTime(this.currentTime);
        rfa.setRollingPolicy((RollingPolicy)tbrp);
        rfa.start();
        rfa.doAppend((Object)"Hello 0");
        filenames[0] = this.randomOutputDirAsStr + "test-" + sdf.format(this.currentTime);
        this.currentTime += 1000L - this.currentTime % 1000L + 50L;
        tbnatp.setCurrentTime(this.currentTime);
        rfa.doAppend((Object)"Hello 1");
        filenames[1] = this.randomOutputDirAsStr + "test-" + sdf.format(this.currentTime);
        for (int i = 0; i < filenames.length; ++i) {
            Assert.assertTrue((boolean)Compare.compare(filenames[i], "src/test/witness/rolling/renaming." + i));
        }
    }

    @Test
    public void renameToNonExistingDirectory() throws IOException, RolloverFailure {
        RenameUtil renameUtil = new RenameUtil();
        renameUtil.setContext(this.context);
        int diff2 = RandomUtil.getPositiveInt();
        File fromFile = File.createTempFile("from" + this.diff, "test", this.randomOutputDir);
        String randomTARGETDir = "target/test-output/" + diff2;
        renameUtil.rename(fromFile.toString(), new File(randomTARGETDir + "/to.test").toString());
        StatusPrinter.printInCaseOfErrorsOrWarnings((Context)this.context);
        Assert.assertTrue((boolean)this.statusChecker.isErrorFree());
    }
}

